/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuoteImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.jetbrains.annotations.NotNull;

public class MarkdownEnterHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiElement psiElement;
        if (file == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(4);
        }
        if ((psiElement = file.findElementAt((Integer)caretOffset.get() - 1)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!MarkdownEnterHandler.shouldHandle(editor, dataContext, psiElement)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (MarkdownEnterHandler.processCodeFence(editor, psiElement)) {
            return EnterHandlerDelegate.Result.Stop;
        }
        if (MarkdownEnterHandler.processBlockQuote(editor, psiElement)) {
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean processBlockQuote(@NotNull Editor editor, @NotNull PsiElement element) {
        MarkdownBlockQuoteImpl blockQuote;
        if (editor == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(5);
        }
        if (element == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(6);
        }
        if ((blockQuote = (MarkdownBlockQuoteImpl)PsiTreeUtil.getParentOfType((PsiElement)element, MarkdownBlockQuoteImpl.class)) != null) {
            MarkdownListItemImpl listItem = (MarkdownListItemImpl)PsiTreeUtil.getParentOfType((PsiElement)blockQuote, MarkdownListItemImpl.class);
            if (listItem == null) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n>");
            } else {
                String indent = StringUtil.repeat((String)" ", (int)(blockQuote.getTextOffset() - listItem.getTextOffset()));
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + indent + ">"));
            }
            return true;
        }
        return false;
    }

    private static boolean processCodeFence(@NotNull Editor editor, @NotNull PsiElement element) {
        PsiLanguageInjectionHost codeFence;
        if (editor == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(7);
        }
        if (element == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(8);
        }
        if (!((codeFence = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element)) instanceof MarkdownCodeFenceImpl)) {
            codeFence = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)element, MarkdownCodeFenceImpl.class);
        }
        if (codeFence != null) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + MarkdownCodeFenceImpl.calculateIndent((MarkdownPsiElement)codeFence)));
            return true;
        }
        return false;
    }

    private static boolean shouldHandle(@NotNull Editor editor, @NotNull DataContext dataContext, @NotNull PsiElement element) {
        Project project;
        if (editor == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(10);
        }
        if (element == null) {
            MarkdownEnterHandler.$$$reportNull$$$0(11);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return false;
        }
        Document editorDocument = editor.getDocument();
        if (!editorDocument.isWritable()) {
            return false;
        }
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile(element);
        if (!(topLevelFile instanceof MarkdownFile)) {
            return false;
        }
        return !editor.isViewer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/editor/MarkdownEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processBlockQuote";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processCodeFence";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHandle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

