/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public interface ElementFilter<T> {
    public boolean shouldBeShowing(T var1);

    public static interface Listener<T> {
        @NotNull
        public Promise<Void> update(@Nullable T var1, boolean var2, boolean var3);
    }

    public static interface Active<T>
    extends ElementFilter<T> {
        @NotNull
        public Promise<?> fireUpdate(@Nullable T var1, boolean var2, boolean var3);

        public void addListener(Listener<T> var1, Disposable var2);

        public static abstract class Impl<T>
        implements Active<T> {
            Set<Listener<T>> myListeners = new CopyOnWriteArraySet<Listener<T>>();

            @Override
            @NotNull
            public Promise<?> fireUpdate(@Nullable T preferredSelection, boolean adjustSelection, boolean now) {
                Promise promise = Promises.all((Collection)ContainerUtil.map(this.myListeners, listener2 -> listener2.update(preferredSelection, adjustSelection, now)));
                if (promise == null) {
                    Impl.$$$reportNull$$$0(0);
                }
                return promise;
            }

            @Override
            public void addListener(final Listener<T> listener2, Disposable parent) {
                this.myListeners.add(listener2);
                Disposer.register((Disposable)parent, (Disposable)new Disposable(){

                    public void dispose() {
                        myListeners.remove(listener2);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/speedSearch/ElementFilter$Active$Impl", "fireUpdate"));
            }
        }
    }
}

