/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.RefCountingRecordsTable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.NotNull;

public class RefCountingStorage
extends AbstractStorage {
    private final Map<Integer, Future<?>> myPendingWriteRequests = new ConcurrentHashMap();
    private int myPendingWriteRequestsSize;
    private final ExecutorService myPendingWriteRequestsExecutor = this.createExecutor();
    private final boolean myDoNotZipCaches;
    private static final int MAX_PENDING_WRITE_SIZE = 0x1400000;

    @NotNull
    protected ExecutorService createExecutor() {
        return new ThreadPoolExecutor(1, 1, Long.MAX_VALUE, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory("RefCountingStorage write content helper"));
    }

    public RefCountingStorage(String path) throws IOException {
        this(path, CapacityAllocationPolicy.DEFAULT);
    }

    public RefCountingStorage(String path, CapacityAllocationPolicy capacityAllocationPolicy) throws IOException {
        this(path, capacityAllocationPolicy, (boolean)Boolean.valueOf(System.getProperty("idea.doNotZipCaches")));
    }

    public RefCountingStorage(String path, CapacityAllocationPolicy capacityAllocationPolicy, boolean doNotZipCaches) throws IOException {
        super(path, capacityAllocationPolicy, true);
        this.myDoNotZipCaches = doNotZipCaches;
    }

    @Override
    public DataInputStream readStream(int record) throws IOException {
        if (this.myDoNotZipCaches) {
            return super.readStream(record);
        }
        BufferExposingByteArrayOutputStream stream = this.internalReadStream(record);
        return new DataInputStream(stream.toInputStream());
    }

    @Override
    protected byte[] readBytes(int record) throws IOException {
        if (this.myDoNotZipCaches) {
            return super.readBytes(record);
        }
        return this.internalReadStream(record).toByteArray();
    }

    private BufferExposingByteArrayOutputStream internalReadStream(int record) throws IOException {
        this.waitForPendingWriteForRecord(record);
        byte[] result = this.withReadLock(() -> super.readBytes(record));
        try (CustomInflaterInputStream in = new CustomInflaterInputStream(result);){
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            StreamUtil.copyStreamContent(in, outputStream);
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = outputStream;
            return bufferExposingByteArrayOutputStream;
        }
    }

    private void waitForPendingWriteForRecord(int record) {
        Future<?> future = this.myPendingWriteRequests.get(record);
        if (future != null) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void appendBytes(int record, ByteArraySequence bytes) {
        throw new IncorrectOperationException("Appending is not supported");
    }

    @Override
    public void writeBytes(int record, ByteArraySequence bytes, boolean fixedSize) throws IOException {
        if (this.myDoNotZipCaches) {
            super.writeBytes(record, bytes, fixedSize);
            return;
        }
        this.waitForPendingWriteForRecord(record);
        this.withWriteLock(() -> {
            this.myPendingWriteRequestsSize += bytes.getLength();
            if (this.myPendingWriteRequestsSize > 0x1400000) {
                this.zipAndWrite(bytes, record, fixedSize);
            } else {
                this.myPendingWriteRequests.put(record, this.myPendingWriteRequestsExecutor.submit(() -> {
                    this.zipAndWrite(bytes, record, fixedSize);
                    return null;
                }));
            }
        });
    }

    private void zipAndWrite(ByteArraySequence bytes, int record, boolean fixedSize) throws IOException {
        BufferExposingByteArrayOutputStream s = new BufferExposingByteArrayOutputStream();
        try (DeflaterOutputStream out = new DeflaterOutputStream(s);){
            out.write(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
        }
        this.withWriteLock(() -> {
            this.doWrite(record, fixedSize, s);
            this.myPendingWriteRequestsSize -= bytes.getLength();
            this.myPendingWriteRequests.remove(record);
        });
    }

    private void doWrite(int record, boolean fixedSize, BufferExposingByteArrayOutputStream s) throws IOException {
        super.writeBytes(record, s.toByteArraySequence(), fixedSize);
    }

    @Override
    protected AbstractRecordsTable createRecordsTable(PagePool pool, File recordsFile) throws IOException {
        return new RefCountingRecordsTable(recordsFile, pool);
    }

    public int acquireNewRecord() throws IOException {
        return this.withWriteLock(() -> {
            int record = this.myRecordsTable.createNewRecord();
            ((RefCountingRecordsTable)this.myRecordsTable).incRefCount(record);
            return record;
        });
    }

    public void acquireRecord(int record) {
        this.waitForPendingWriteForRecord(record);
        this.withWriteLock(() -> ((RefCountingRecordsTable)this.myRecordsTable).incRefCount(record));
    }

    public void releaseRecord(int record) throws IOException {
        this.releaseRecord(record, true);
    }

    public void releaseRecord(int record, boolean completely) throws IOException {
        this.waitForPendingWriteForRecord(record);
        this.withWriteLock(() -> {
            if (((RefCountingRecordsTable)this.myRecordsTable).decRefCount(record) && completely) {
                this.doDeleteRecord(record);
            }
        });
    }

    public int getRefCount(int record) {
        this.waitForPendingWriteForRecord(record);
        return this.withReadLock(() -> ((RefCountingRecordsTable)this.myRecordsTable).getRefCount(record));
    }

    @Override
    public void force() {
        this.flushPendingWrites();
        super.force();
    }

    @Override
    public boolean isDirty() {
        return !this.myPendingWriteRequests.isEmpty() || super.isDirty();
    }

    @Override
    public boolean flushSome() {
        this.flushPendingWrites();
        return super.flushSome();
    }

    @Override
    public void dispose() {
        this.flushPendingWrites();
        super.dispose();
    }

    @Override
    public void checkSanity(int record) {
        this.flushPendingWrites();
        super.checkSanity(record);
    }

    private void flushPendingWrites() {
        for (Map.Entry<Integer, Future<?>> entry : this.myPendingWriteRequests.entrySet()) {
            try {
                entry.getValue().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class CustomInflaterInputStream
    extends InflaterInputStream {
        CustomInflaterInputStream(byte[] compressedData) {
            super(new UnsyncByteArrayInputStream(compressedData), new Inflater(), 1);
            this.buf = compressedData;
            this.len = -1;
        }

        @Override
        protected void fill() throws IOException {
            if (this.len >= 0) {
                throw new EOFException();
            }
            this.len = this.buf.length;
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.inf.end();
        }
    }
}

