/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.Util;

public abstract class Sort
extends SingleRel {
    public final RelCollation collation;
    protected final ImmutableList<RexNode> fieldExps;
    public final RexNode offset;
    public final RexNode fetch;

    public Sort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation) {
        this(cluster, traits, child, collation, null, null);
    }

    public Sort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traits, child);
        this.collation = collation;
        this.offset = offset;
        this.fetch = fetch;
        assert (traits.containsIfApplicable(collation)) : "traits=" + traits + ", collation=" + collation;
        assert (fetch != null || offset != null || !collation.getFieldCollations().isEmpty()) : "trivial sort";
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RelFieldCollation field : collation.getFieldCollations()) {
            int index = field.getFieldIndex();
            builder.add((Object)cluster.getRexBuilder().makeInputRef(child, index));
        }
        this.fieldExps = builder.build();
    }

    public Sort(RelInput input) {
        this(input.getCluster(), input.getTraitSet().plus(input.getCollation()), input.getInput(), RelCollationTraitDef.INSTANCE.canonize(input.getCollation()), input.getExpression("offset"), input.getExpression("fetch"));
    }

    @Override
    public final Sort copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Sort.sole(inputs), this.collation, this.offset, this.fetch);
    }

    public final Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation) {
        return this.copy(traitSet, newInput, newCollation, this.offset, this.fetch);
    }

    public abstract Sort copy(RelTraitSet var1, RelNode var2, RelCollation var3, RexNode var4, RexNode var5);

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        double bytesPerRow = this.getRowType().getFieldCount() * 4;
        double cpu = Util.nLogN(rowCount) * bytesPerRow;
        return planner.getCostFactory().makeCost(rowCount, cpu, 0.0);
    }

    @Override
    public List<RexNode> getChildExps() {
        return this.fieldExps;
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode offset = shuttle.apply(this.offset);
        RexNode fetch = shuttle.apply(this.fetch);
        List<RexNode> fieldExps = shuttle.apply(this.fieldExps);
        assert (fieldExps == this.fieldExps) : "Sort node does not support modification of input field expressions. Old expressions: " + this.fieldExps + ", new ones: " + fieldExps;
        if (offset == this.offset && fetch == this.fetch) {
            return this;
        }
        return this.copy(this.traitSet, this.getInput(), this.collation, offset, fetch);
    }

    public RelCollation getCollation() {
        return this.collation;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return Collections.singletonList(this.getCollation());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        assert (this.fieldExps.size() == this.collation.getFieldCollations().size());
        if (pw.nest()) {
            pw.item("collation", this.collation);
        } else {
            for (Ord ord : Ord.zip(this.fieldExps)) {
                pw.item("sort" + ord.i, ord.e);
            }
            for (Ord ord : Ord.zip(this.collation.getFieldCollations())) {
                pw.item("dir" + ord.i, ((RelFieldCollation)ord.e).shortString());
            }
        }
        pw.itemIf("offset", this.offset, this.offset != null);
        pw.itemIf("fetch", this.fetch, this.fetch != null);
        return pw;
    }
}

