/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Date;
import java.util.function.IntFunction;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessor;
import org.apache.solr.search.facet.SlotAcc;

abstract class FacetFieldProcessorByArray
extends FacetFieldProcessor {
    BytesRefBuilder prefixRef;
    int startTermIndex;
    int endTermIndex;
    int nTerms;
    int nDocs;
    int maxSlots;
    int allBucketsSlot = -1;
    public IntFunction<SlotAcc.SlotContext> slotContext = slotNum -> {
        try {
            Object value = this.sf.getType().toObject(this.sf, this.lookupOrd(slotNum + this.startTermIndex));
            Query q = this.makeBucketQuery(FacetFieldProcessorByArray.valueObjToString(value));
            assert (null != q) : "null query for: '" + value + "'";
            return new SlotAcc.SlotContext(q);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };

    FacetFieldProcessorByArray(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
    }

    protected abstract void findStartAndEndOrds() throws IOException;

    protected abstract void collectDocs() throws IOException;

    protected abstract BytesRef lookupOrd(int var1) throws IOException;

    @Override
    public void process() throws IOException {
        super.process();
        this.response = this.calcFacets();
    }

    private SimpleOrderedMap<Object> calcFacets() throws IOException {
        String prefix;
        boolean skipThisFacet;
        SimpleOrderedMap<Object> refineResult = null;
        boolean bl = skipThisFacet = (this.fcontext.flags & 4) != 0;
        if (this.fcontext.facetInfo != null) {
            refineResult = this.refineFacets();
            if (skipThisFacet || !((FacetField)this.freq).allBuckets) {
                return refineResult;
            }
        }
        if ((prefix = ((FacetField)this.freq).prefix) == null || prefix.length() == 0) {
            this.prefixRef = null;
        } else {
            this.prefixRef = new BytesRefBuilder();
            this.prefixRef.copyChars((CharSequence)prefix);
        }
        this.findStartAndEndOrds();
        if (refineResult != null && ((FacetField)this.freq).allBuckets) {
            this.countAcc = SlotAcc.DEV_NULL_SLOT_ACC;
            this.createAccs(this.nDocs, 1);
            this.otherAccs = this.accs;
            this.allBucketsAcc = new FacetFieldProcessor.SpecialSlotAcc(this.fcontext, null, -1, this.accs, 0);
            this.collectDocs();
            SimpleOrderedMap allBuckets = new SimpleOrderedMap();
            allBuckets.add("count", (Object)this.allBucketsAcc.getSpecialCount());
            this.allBucketsAcc.setValues((SimpleOrderedMap<Object>)allBuckets, -1);
            refineResult.add("allBuckets", (Object)allBuckets);
            return refineResult;
        }
        this.maxSlots = this.nTerms;
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsSlot = this.maxSlots++;
        }
        this.createCollectAcc(this.nDocs, this.maxSlots);
        if (((FacetField)this.freq).allBuckets) {
            this.allBucketsAcc = new FacetFieldProcessor.SpecialSlotAcc(this.fcontext, this.collectAcc, this.allBucketsSlot, this.otherAccs, 0);
        }
        this.collectDocs();
        return super.findTopSlots(this.nTerms, this.nTerms, slotNum -> {
            try {
                return (Comparable)this.sf.getType().toObject(this.sf, this.lookupOrd(slotNum + this.startTermIndex));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, obj -> FacetFieldProcessorByArray.valueObjToString(obj));
    }

    private static String valueObjToString(Object obj) {
        return obj instanceof Date ? ((Date)obj).toInstant().toString() : obj.toString();
    }
}

