/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.imageio.ImageIO;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;
import org.openide.awt.SwingBrowserImpl;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HtmlBrowser
extends JPanel {
    private static final long serialVersionUID = 2912844785502987960L;
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 600;
    private static Factory browserFactory;
    private static String homePage;
    private Icon iBack;
    private Icon iForward;
    private Icon iHome;
    private Icon iReload;
    private Icon iStop;
    private Icon iHistory;
    final Impl browserImpl;
    private boolean everythinkIListenInCheckBoxIsUnimportant = false;
    private boolean toolbarVisible = false;
    private boolean statusLineVisible = false;
    private BrowserListener browserListener;
    private JButton bBack;
    private JButton bForward;
    private JButton bHome;
    private JButton bReload;
    private JButton bStop;
    private JButton bHistory;
    private JComboBox cbLocation;
    private JLabel cbLabel;
    private JLabel lStatusLine;
    final Component browserComponent;
    private JPanel head;
    private RequestProcessor rp = new RequestProcessor();

    public HtmlBrowser() {
        this(true, true);
    }

    public HtmlBrowser(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    public HtmlBrowser(Factory factory, boolean bl, boolean bl2) {
        this.init();
        Impl impl = null;
        Component component = null;
        try {
            if (factory == null) {
                Impl[] implArray = new Impl[1];
                component = HtmlBrowser.findComponent(implArray);
                impl = implArray[0];
            } else {
                try {
                    impl = factory.createHtmlBrowserImpl();
                    component = impl.getComponent();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Exceptions.printStackTrace((Throwable)unsupportedOperationException);
                    impl = new SwingBrowserImpl();
                    component = impl.getComponent();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            Exceptions.attachLocalizedMessage((Throwable)runtimeException, (String)NbBundle.getMessage(HtmlBrowser.class, (String)"EXC_Module"));
            Exceptions.printStackTrace((Throwable)runtimeException);
        }
        this.browserImpl = impl;
        this.browserComponent = component;
        this.setLayout(new BorderLayout(0, 2));
        this.add((Component)(this.browserComponent != null ? new JScrollPane(this.browserComponent) : new JScrollPane()), "Center");
        this.browserListener = new BrowserListener();
        if (bl) {
            this.initToolbar();
        }
        if (bl2) {
            this.initStatusLine();
        }
        this.browserImpl.addPropertyChangeListener(this.browserListener);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HtmlBrowser.class, (String)"ACS_HtmlBrowser"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HtmlBrowser.class, (String)"ACSD_HtmlBrowser"));
    }

    public static void setHomePage(String string) {
        homePage = string;
    }

    public static String getHomePage() {
        if (homePage == null) {
            return NbBundle.getMessage(HtmlBrowser.class, (String)"PROP_HomePage");
        }
        return homePage;
    }

    public static void setFactory(Factory factory) {
        browserFactory = factory;
    }

    private static Component findComponent(Impl[] implArray) {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(Factory.class));
        for (Factory factory : result.allInstances()) {
            try {
                Impl impl = factory.createHtmlBrowserImpl();
                Component component = impl != null ? impl.getComponent() : null;
                if (component == null) continue;
                implArray[0] = impl;
                return component;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        Factory factory = browserFactory;
        if (factory != null) {
            try {
                implArray[0] = factory.createHtmlBrowserImpl();
                return implArray[0].getComponent();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        implArray[0] = new SwingBrowserImpl();
        return implArray[0].getComponent();
    }

    private void init() {
        try {
            if (this.iBack != null) {
                return;
            }
            this.iBack = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/back.gif")));
            this.iForward = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/forward.gif")));
            this.iHome = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/home.gif")));
            this.iReload = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/refresh.gif")));
            this.iStop = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/stop.gif")));
            this.iHistory = new ImageIcon(ImageIO.read(HtmlBrowser.class.getResource("/org/openide/resources/html/history.gif")));
        }
        catch (IOException iOException) {
            Logger.getLogger(HtmlBrowser.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
        }
    }

    private void initToolbar() {
        this.toolbarVisible = true;
        this.head = new JPanel();
        this.head.setLayout(new BorderLayout(11, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.bBack = new JButton(this.iBack);
        jPanel.add(this.bBack);
        this.bBack.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Back"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.bForward = new JButton(this.iForward);
        jPanel.add((Component)this.bForward, gridBagConstraints);
        this.bForward.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Forward"));
        this.bStop = new JButton(this.iStop);
        jPanel.add(this.bStop);
        this.bStop.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Stop"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.bReload = new JButton(this.iReload);
        jPanel.add((Component)this.bReload, gridBagConstraints);
        this.bReload.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Reload"));
        this.bHome = new JButton(this.iHome);
        jPanel.add(this.bHome);
        this.bHome.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Home"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.bHistory = new JButton(this.iHistory);
        jPanel.add((Component)this.bHistory, gridBagConstraints);
        this.bHistory.setToolTipText(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_History"));
        if (this.browserImpl != null) {
            this.bBack.setEnabled(this.browserImpl.isBackward());
            this.bForward.setEnabled(this.browserImpl.isForward());
            this.bHistory.setEnabled(this.browserImpl.isHistory());
        }
        JToolBar.Separator separator = new JToolBar.Separator();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)separator, gridBagConstraints);
        separator.updateUI();
        this.cbLabel = new JLabel();
        jPanel.add(this.cbLabel);
        Mnemonics.setLocalizedText(this.cbLabel, NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Location"));
        this.head.add("West", jPanel);
        this.cbLocation = new JComboBox();
        this.head.add("Center", this.cbLocation);
        this.cbLocation.setEditable(true);
        this.cbLabel.setLabelFor(this.cbLocation);
        this.add((Component)this.head, "North");
        this.cbLocation.addActionListener(this.browserListener);
        this.bHistory.addActionListener(this.browserListener);
        this.bBack.addActionListener(this.browserListener);
        this.bForward.addActionListener(this.browserListener);
        this.bReload.addActionListener(this.browserListener);
        this.bHome.addActionListener(this.browserListener);
        this.bStop.addActionListener(this.browserListener);
        this.bHistory.getAccessibleContext().setAccessibleName(this.bHistory.getToolTipText());
        this.bBack.getAccessibleContext().setAccessibleName(this.bBack.getToolTipText());
        this.bForward.getAccessibleContext().setAccessibleName(this.bForward.getToolTipText());
        this.bReload.getAccessibleContext().setAccessibleName(this.bReload.getToolTipText());
        this.bHome.getAccessibleContext().setAccessibleName(this.bHome.getToolTipText());
        this.bStop.getAccessibleContext().setAccessibleName(this.bStop.getToolTipText());
        this.cbLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HtmlBrowser.class, (String)"ACSD_HtmlBrowser_Location"));
    }

    private void destroyToolbar() {
        this.remove(this.head);
        this.head = null;
        this.toolbarVisible = false;
    }

    private void initStatusLine() {
        this.statusLineVisible = true;
        this.lStatusLine = new JLabel(NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Loading"));
        this.add((Component)this.lStatusLine, "South");
        this.lStatusLine.setLabelFor(this);
    }

    private void destroyStatusLine() {
        this.remove(this.lStatusLine);
        this.lStatusLine = null;
        this.statusLineVisible = false;
    }

    public void setURL(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL("http://" + string);
            }
            catch (MalformedURLException malformedURLException2) {
                if (this.browserImpl instanceof SwingBrowserImpl) {
                    ((SwingBrowserImpl)this.browserImpl).setStatusText(NbBundle.getMessage(SwingBrowserImpl.class, (String)"FMT_InvalidURL", (Object[])new Object[]{string}));
                } else {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
                return;
            }
        }
        this.setURL(uRL);
    }

    public void setURL(final URL uRL) {
        if (uRL == null) {
            return;
        }
        HtmlBrowser htmlBrowser = this;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class URLSetter
        implements Runnable {
            private boolean sameHosts = false;

            URLSetter() {
            }

            @Override
            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    this.sameHosts = "nbfs".equals(uRL.getProtocol()) ? true : uRL.getHost() != null && HtmlBrowser.this.browserImpl.getURL() != null && uRL.getHost().equals(HtmlBrowser.this.browserImpl.getURL().getHost());
                    SwingUtilities.invokeLater(this);
                } else if (uRL.equals(HtmlBrowser.this.browserImpl.getURL()) && this.sameHosts) {
                    HtmlBrowser.this.browserImpl.reloadDocument();
                } else {
                    HtmlBrowser.this.browserImpl.setURL(uRL);
                }
            }
        }
        htmlBrowser.rp.getDefault().post((Runnable)new URLSetter());
    }

    public final URL getDocumentURL() {
        return this.browserImpl.getURL();
    }

    public final void setEnableHome(boolean bl) {
        this.bHome.setEnabled(bl);
        this.bHome.setVisible(bl);
    }

    public final void setEnableLocation(boolean bl) {
        this.cbLocation.setEditable(bl);
        this.cbLocation.setVisible(bl);
        this.cbLabel.setVisible(bl);
    }

    public boolean isStatusLineVisible() {
        return this.statusLineVisible;
    }

    public void setStatusLineVisible(boolean bl) {
        if (bl == this.statusLineVisible) {
            return;
        }
        if (bl) {
            this.initStatusLine();
        } else {
            this.destroyStatusLine();
        }
    }

    public boolean isToolbarVisible() {
        return this.toolbarVisible;
    }

    public void setToolbarVisible(boolean bl) {
        if (bl == this.toolbarVisible) {
            return;
        }
        if (bl) {
            this.initToolbar();
        } else {
            this.destroyToolbar();
        }
    }

    public final Impl getBrowserImpl() {
        return this.browserImpl;
    }

    public final Component getBrowserComponent() {
        return this.browserComponent;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(400, dimension.width), Math.max(600, dimension.height));
    }

    private void updateLocationBar() {
        if (this.toolbarVisible) {
            this.everythinkIListenInCheckBoxIsUnimportant = true;
            URL uRL = this.browserImpl.getURL();
            if (uRL != null) {
                this.cbLocation.setSelectedItem(uRL.toString());
            }
            this.everythinkIListenInCheckBoxIsUnimportant = false;
        }
    }

    public void requestFocus() {
        if (this.browserComponent != null) {
            boolean bl = false;
            if (this.browserComponent instanceof JComponent) {
                bl = ((JComponent)this.browserComponent).requestDefaultFocus();
            }
            if (!bl) {
                this.browserComponent.requestFocus();
            }
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.browserComponent != null) {
            boolean bl = false;
            if (this.browserComponent instanceof JComponent) {
                bl = ((JComponent)this.browserComponent).requestDefaultFocus();
            }
            if (!bl) {
                return this.browserComponent.requestFocusInWindow();
            }
            return true;
        }
        return super.requestFocusInWindow();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHtmlBrowser();
        }
        return this.accessibleContext;
    }

    static {
        homePage = null;
    }

    private class AccessibleHtmlBrowser
    extends JPanel.AccessibleJPanel {
        AccessibleHtmlBrowser() {
            super(HtmlBrowser.this);
        }

        public void setAccessibleName(String string) {
            super.setAccessibleName(string);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleName(string);
            }
        }

        public void setAccessibleDescription(String string) {
            super.setAccessibleDescription(string);
            if (HtmlBrowser.this.browserComponent instanceof Accessible) {
                HtmlBrowser.this.browserComponent.getAccessibleContext().setAccessibleDescription(string);
            }
        }
    }

    private class BrowserListener
    implements ActionListener,
    PropertyChangeListener {
        BrowserListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            if (string.equals("url") || string.equals("title")) {
                HtmlBrowser.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
            if (string.equals("url")) {
                HtmlBrowser.this.updateLocationBar();
            } else if (string.equals("statusMessage")) {
                String string2 = HtmlBrowser.this.browserImpl.getStatusMessage();
                if (string2 == null || string2.length() < 1) {
                    string2 = NbBundle.getMessage(HtmlBrowser.class, (String)"CTL_Document_done");
                }
                if (HtmlBrowser.this.lStatusLine != null) {
                    HtmlBrowser.this.lStatusLine.setText(string2);
                }
            } else if (string.equals("forward") && HtmlBrowser.this.bForward != null) {
                HtmlBrowser.this.bForward.setEnabled(HtmlBrowser.this.browserImpl.isForward());
            } else if (string.equals("backward") && HtmlBrowser.this.bBack != null) {
                HtmlBrowser.this.bBack.setEnabled(HtmlBrowser.this.browserImpl.isBackward());
            } else if (string.equals("history") && HtmlBrowser.this.bHistory != null) {
                HtmlBrowser.this.bHistory.setEnabled(HtmlBrowser.this.browserImpl.isHistory());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == HtmlBrowser.this.cbLocation) {
                int n;
                if (HtmlBrowser.this.everythinkIListenInCheckBoxIsUnimportant) {
                    return;
                }
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object == null) {
                    return;
                }
                HtmlBrowser.this.setURL((String)object);
                ComboBoxModel comboBoxModel = jComboBox.getModel();
                int n2 = comboBoxModel.getSize();
                for (n = 0; n < n2 && !object.equals(comboBoxModel.getElementAt(n)); ++n) {
                }
                if (n != n2) {
                    return;
                }
                if (n2 == 20) {
                    jComboBox.removeItem(comboBoxModel.getElementAt(n2 - 1));
                }
                jComboBox.insertItemAt(object, 0);
            } else if (actionEvent.getSource() == HtmlBrowser.this.bHistory) {
                HtmlBrowser.this.browserImpl.showHistory();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bBack) {
                HtmlBrowser.this.browserImpl.backward();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bForward) {
                HtmlBrowser.this.browserImpl.forward();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bReload) {
                HtmlBrowser.this.updateLocationBar();
                HtmlBrowser.this.browserImpl.reloadDocument();
            } else if (actionEvent.getSource() == HtmlBrowser.this.bHome) {
                HtmlBrowser.this.setURL(HtmlBrowser.getHomePage());
            } else if (actionEvent.getSource() == HtmlBrowser.this.bStop) {
                HtmlBrowser.this.browserImpl.stopLoading();
            }
        }
    }

    public static interface Factory {
        public Impl createHtmlBrowserImpl();
    }

    public static abstract class Impl {
        static final long serialVersionUID = 2912844785502962114L;
        public static final String PROP_STATUS_MESSAGE = "statusMessage";
        public static final String PROP_URL = "url";
        public static final String PROP_TITLE = "title";
        public static final String PROP_FORWARD = "forward";
        public static final String PROP_BACKWARD = "backward";
        public static final String PROP_HISTORY = "history";

        public abstract Component getComponent();

        public abstract void reloadDocument();

        public abstract void stopLoading();

        public abstract void setURL(URL var1);

        public abstract URL getURL();

        public abstract String getStatusMessage();

        public abstract String getTitle();

        public abstract boolean isForward();

        public abstract void forward();

        public abstract boolean isBackward();

        public abstract void backward();

        public abstract boolean isHistory();

        public abstract void showHistory();

        public abstract void addPropertyChangeListener(PropertyChangeListener var1);

        public abstract void removePropertyChangeListener(PropertyChangeListener var1);
    }

    private static final class TrivialURLDisplayer
    extends URLDisplayer {
        public void showURL(URL uRL) {
            HtmlBrowser htmlBrowser = new HtmlBrowser();
            htmlBrowser.setURL(uRL);
            JFrame jFrame = new JFrame();
            jFrame.setDefaultCloseOperation(2);
            jFrame.getContentPane().add(htmlBrowser);
            jFrame.pack();
            jFrame.setVisible(true);
        }
    }

    public static abstract class URLDisplayer {
        protected URLDisplayer() {
        }

        public static URLDisplayer getDefault() {
            URLDisplayer uRLDisplayer = (URLDisplayer)Lookup.getDefault().lookup(URLDisplayer.class);
            if (uRLDisplayer == null) {
                uRLDisplayer = new TrivialURLDisplayer();
            }
            return uRLDisplayer;
        }

        public abstract void showURL(URL var1);
    }
}

