/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.util;

import de.rub.nds.tlsattacker.core.constants.CipherSuite;

public enum ServerCertificateKey {
    EC,
    DH,
    RSA,
    NONE;


    public static ServerCertificateKey getServerCertificateKey(CipherSuite cipherSuite) {
        String cipher = cipherSuite.toString().toUpperCase();
        if (cipher.startsWith("TLS_RSA") || cipher.matches("^TLS_[A-Z]+_RSA.+")) {
            return RSA;
        }
        if (cipher.matches("^TLS_[A-Z]+_DSS.+")) {
            return DH;
        }
        if (cipher.matches("^TLS_[A-Z]+_ECDSA.+")) {
            return EC;
        }
        return NONE;
    }
}

