/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

import com.cloudhopper.commons.charset.BaseCharset;
import com.cloudhopper.commons.charset.CharSequenceAccessor;

public class ModifiedUTF8Charset
extends BaseCharset {
    @Override
    public int estimateEncodeByteLength(CharSequence str0) {
        return ModifiedUTF8Charset.calculateByteLength(str0);
    }

    @Override
    public int estimateDecodeCharLength(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        return bytes.length;
    }

    @Override
    public byte[] encode(CharSequence charSeq) {
        if (charSeq == null) {
            return null;
        }
        CharSequenceAccessor.CharArrayWrapper wrapper = CharSequenceAccessor.access(charSeq);
        if (wrapper != null) {
            int utf8len = ModifiedUTF8Charset.calculateByteLength(null, wrapper.value, wrapper.offset, wrapper.length);
            byte[] buf = new byte[utf8len];
            ModifiedUTF8Charset.encodeToByteArray(null, wrapper.value, wrapper.offset, wrapper.length, buf, 0);
            return buf;
        }
        int utf8len = ModifiedUTF8Charset.calculateByteLength(charSeq, null, 0, 0);
        byte[] buf = new byte[utf8len];
        ModifiedUTF8Charset.encodeToByteArray(charSeq, null, 0, 0, buf, 0);
        return buf;
    }

    @Override
    public void decode(byte[] bytes, StringBuilder buffer) {
        if (bytes == null) {
            return;
        }
        buffer.ensureCapacity(buffer.length() + bytes.length);
        CharSequenceAccessor.CharArrayWrapper wrapper = CharSequenceAccessor.access(buffer);
        int charLength = ModifiedUTF8Charset.decodeToCharArray(bytes, 0, bytes.length, wrapper.value, wrapper.length);
        CharSequenceAccessor.updateStringBuilder(buffer, charLength + wrapper.length);
    }

    @Override
    public String decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] charBuffer = new char[bytes.length];
        int charLength = ModifiedUTF8Charset.decodeToCharArray(bytes, 0, bytes.length, charBuffer, 0);
        return CharSequenceAccessor.createOptimizedString(charBuffer, 0, charLength);
    }

    public String decode(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        char[] charBuffer = new char[bytes.length];
        int charLength = ModifiedUTF8Charset.decodeToCharArray(bytes, offset, length, charBuffer, 0);
        return CharSequenceAccessor.createOptimizedString(charBuffer, 0, charLength);
    }

    public static int calculateByteLength(CharSequence charSeq) {
        return ModifiedUTF8Charset.calculateByteLength(charSeq, null, 0, 0);
    }

    public static int calculateByteLength(CharSequence charSeq, char[] charBuffer, int charOffset, int charLength) {
        char c = '\u0000';
        int byteLength = 0;
        int charPos = charOffset;
        int charAbsLength = charPos + charLength;
        if (charBuffer == null) {
            if (charSeq == null) {
                return 0;
            }
            charOffset = 0;
            charAbsLength = charSeq.length();
        }
        while (charPos < charAbsLength) {
            c = charBuffer != null ? charBuffer[charPos] : charSeq.charAt(charPos);
            byteLength = c >= '\u0000' && c <= '\u007f' ? ++byteLength : (c > '\u07ff' ? (byteLength += 3) : (byteLength += 2));
            ++charPos;
        }
        return byteLength;
    }

    public static int encodeToByteArray(CharSequence charSeq, char[] charBuffer, int charOffset, int charLength, byte[] byteBuffer, int byteOffset) {
        char c = '\u0000';
        int bytePos = byteOffset;
        int charPos = charOffset;
        int charAbsLength = charPos + charLength;
        if (charBuffer == null) {
            if (charSeq == null) {
                throw new IllegalArgumentException("Both charSeq and charBuffer cannot be null");
            }
            charOffset = 0;
            charAbsLength = charSeq.length();
        }
        while (charPos < charAbsLength && (c = charBuffer != null ? charBuffer[charPos] : charSeq.charAt(charPos)) >= '\u0000' && c <= '\u007f') {
            byteBuffer[bytePos++] = (byte)c;
            ++charPos;
        }
        while (charPos < charAbsLength) {
            c = charBuffer != null ? charBuffer[charPos] : charSeq.charAt(charPos);
            if (c >= '\u0000' && c <= '\u007f') {
                byteBuffer[bytePos++] = (byte)c;
            } else if (c > '\u07ff') {
                byteBuffer[bytePos++] = (byte)(0xE0 | c >> 12 & 0xF);
                byteBuffer[bytePos++] = (byte)(0x80 | c >> 6 & 0x3F);
                byteBuffer[bytePos++] = (byte)(0x80 | c & 0x3F);
            } else {
                byteBuffer[bytePos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byteBuffer[bytePos++] = (byte)(0x80 | c & 0x3F);
            }
            ++charPos;
        }
        return bytePos - byteOffset;
    }

    public static int decodeToCharArray(byte[] byteBuffer, int byteOffset, int byteLength, char[] charBuffer, int charOffset) {
        int bytePos;
        int c = 0;
        byte char2 = 0;
        byte char3 = 0;
        int byteAbsLength = byteOffset + byteLength;
        int charPos = charOffset;
        for (bytePos = byteOffset; bytePos < byteAbsLength && (c = byteBuffer[bytePos] & 0xFF) <= 127; ++bytePos) {
            charBuffer[charPos++] = (char)c;
        }
        block6: while (bytePos < byteAbsLength) {
            c = byteBuffer[bytePos] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++bytePos;
                    charBuffer[charPos++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((bytePos += 2) > byteAbsLength) {
                        throw new IllegalArgumentException("malformed input: partial character at end");
                    }
                    char2 = byteBuffer[bytePos - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + bytePos);
                    }
                    charBuffer[charPos++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((bytePos += 3) > byteAbsLength) {
                        throw new IllegalArgumentException("malformed input: partial character at end");
                    }
                    char2 = byteBuffer[bytePos - 2];
                    char3 = byteBuffer[bytePos - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new IllegalArgumentException("malformed input around byte " + (bytePos - 1));
                    }
                    charBuffer[charPos++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("malformed input around byte " + bytePos);
        }
        return charPos - charOffset;
    }
}

