/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import javax.annotation.security.PermitAll;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.BaseResource;
import org.traccar.helper.DataConverter;
import org.traccar.helper.LogAction;
import org.traccar.helper.ServletHelper;
import org.traccar.model.User;

@Path(value="session")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class SessionResource
extends BaseResource {
    public static final String USER_ID_KEY = "userId";
    public static final String USER_COOKIE_KEY = "user";
    public static final String PASS_COOKIE_KEY = "password";
    @javax.ws.rs.core.Context
    private HttpServletRequest request;

    @PermitAll
    @GET
    public User get(@QueryParam(value="token") String token) throws SQLException, UnsupportedEncodingException {
        Long userId = (Long)this.request.getSession().getAttribute(USER_ID_KEY);
        if (userId == null) {
            User user;
            Cookie[] cookies = this.request.getCookies();
            String email = null;
            String password = null;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (cookie.getName().equals(USER_COOKIE_KEY)) {
                        byte[] emailBytes = DataConverter.parseBase64(URLDecoder.decode(cookie.getValue(), StandardCharsets.US_ASCII.name()));
                        email = new String(emailBytes, StandardCharsets.UTF_8);
                        continue;
                    }
                    if (!cookie.getName().equals(PASS_COOKIE_KEY)) continue;
                    byte[] passwordBytes = DataConverter.parseBase64(URLDecoder.decode(cookie.getValue(), StandardCharsets.US_ASCII.name()));
                    password = new String(passwordBytes, StandardCharsets.UTF_8);
                }
            }
            if (email != null && password != null) {
                user = Context.getPermissionsManager().login(email, password);
                if (user != null) {
                    userId = user.getId();
                    this.request.getSession().setAttribute(USER_ID_KEY, (Object)userId);
                }
            } else if (token != null && (user = Context.getUsersManager().getUserByToken(token)) != null) {
                userId = user.getId();
                this.request.getSession().setAttribute(USER_ID_KEY, (Object)userId);
            }
        }
        if (userId != null) {
            Context.getPermissionsManager().checkUserEnabled(userId);
            return Context.getPermissionsManager().getUser(userId);
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @PermitAll
    @POST
    public User add(@FormParam(value="email") String email, @FormParam(value="password") String password) throws SQLException {
        User user = Context.getPermissionsManager().login(email, password);
        if (user != null) {
            this.request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
            LogAction.login(user.getId());
            return user;
        }
        LogAction.failedLogin(ServletHelper.retrieveRemoteAddress(this.request));
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }

    @DELETE
    public Response remove() {
        LogAction.logout(this.getUserId());
        this.request.getSession().removeAttribute(USER_ID_KEY);
        return Response.noContent().build();
    }
}

