/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.DataManager;
import org.traccar.helper.DateUtil;
import org.traccar.model.Statistics;

public class StatisticsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsManager.class);
    private static final int SPLIT_MODE = 5;
    private final Config config;
    private final DataManager dataManager;
    private final Client client;
    private final ObjectMapper objectMapper;
    private final AtomicInteger lastUpdate = new AtomicInteger(Calendar.getInstance().get(5));
    private final Set<Long> users = new HashSet<Long>();
    private final Map<Long, String> deviceProtocols = new HashMap<Long, String>();
    private int requests;
    private int messagesReceived;
    private int messagesStored;
    private int mailSent;
    private int smsSent;
    private int geocoderRequests;
    private int geolocationRequests;

    @Inject
    public StatisticsManager(Config config, DataManager dataManager, Client client, ObjectMapper objectMapper) {
        this.config = config;
        this.dataManager = dataManager;
        this.client = client;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSplit() {
        int currentUpdate = Calendar.getInstance().get(5);
        if (this.lastUpdate.getAndSet(currentUpdate) != currentUpdate) {
            Statistics statistics = new Statistics();
            StatisticsManager statisticsManager = this;
            synchronized (statisticsManager) {
                statistics.setCaptureTime(new Date());
                statistics.setActiveUsers(this.users.size());
                statistics.setActiveDevices(this.deviceProtocols.size());
                statistics.setRequests(this.requests);
                statistics.setMessagesReceived(this.messagesReceived);
                statistics.setMessagesStored(this.messagesStored);
                statistics.setMailSent(this.mailSent);
                statistics.setSmsSent(this.smsSent);
                statistics.setGeocoderRequests(this.geocoderRequests);
                statistics.setGeolocationRequests(this.geolocationRequests);
                if (!this.deviceProtocols.isEmpty()) {
                    HashMap<String, Integer> protocols = new HashMap<String, Integer>();
                    for (String protocol : this.deviceProtocols.values()) {
                        protocols.compute(protocol, (key, count) -> count != null ? count + 1 : 1);
                    }
                    statistics.setProtocols(protocols);
                }
                this.users.clear();
                this.deviceProtocols.clear();
                this.requests = 0;
                this.messagesReceived = 0;
                this.messagesStored = 0;
                this.mailSent = 0;
                this.smsSent = 0;
                this.geocoderRequests = 0;
                this.geolocationRequests = 0;
            }
            try {
                this.dataManager.addObject(statistics);
            }
            catch (SQLException e) {
                LOGGER.warn("Error saving statistics", (Throwable)e);
            }
            String url = this.config.getString(Keys.SERVER_STATISTICS);
            if (url != null) {
                String time = DateUtil.formatDate(statistics.getCaptureTime());
                Form form = new Form();
                form.param("version", this.getClass().getPackage().getImplementationVersion());
                form.param("captureTime", time);
                form.param("activeUsers", String.valueOf(statistics.getActiveUsers()));
                form.param("activeDevices", String.valueOf(statistics.getActiveDevices()));
                form.param("requests", String.valueOf(statistics.getRequests()));
                form.param("messagesReceived", String.valueOf(statistics.getMessagesReceived()));
                form.param("messagesStored", String.valueOf(statistics.getMessagesStored()));
                form.param("mailSent", String.valueOf(statistics.getMailSent()));
                form.param("smsSent", String.valueOf(statistics.getSmsSent()));
                form.param("geocoderRequests", String.valueOf(statistics.getGeocoderRequests()));
                form.param("geolocationRequests", String.valueOf(statistics.getGeolocationRequests()));
                if (statistics.getProtocols() != null) {
                    try {
                        form.param("protocols", this.objectMapper.writeValueAsString(statistics.getProtocols()));
                    }
                    catch (JsonProcessingException e) {
                        LOGGER.warn("Failed to serialize protocols", (Throwable)e);
                    }
                }
                this.client.target(url).request().async().post(Entity.form((Form)form));
            }
        }
    }

    public synchronized void registerRequest(long userId) {
        this.checkSplit();
        ++this.requests;
        if (userId != 0L) {
            this.users.add(userId);
        }
    }

    public synchronized void registerMessageReceived() {
        this.checkSplit();
        ++this.messagesReceived;
    }

    public synchronized void registerMessageStored(long deviceId, String protocol) {
        this.checkSplit();
        ++this.messagesStored;
        if (deviceId != 0L) {
            this.deviceProtocols.put(deviceId, protocol);
        }
    }

    public synchronized void registerMail() {
        this.checkSplit();
        ++this.mailSent;
    }

    public synchronized void registerSms() {
        this.checkSplit();
        ++this.smsSent;
    }

    public synchronized void registerGeocoderRequest() {
        this.checkSplit();
        ++this.geocoderRequests;
    }

    public synchronized void registerGeolocationRequest() {
        this.checkSplit();
        ++this.geolocationRequests;
    }
}

