#!/usr/bin/perl
#  import.pl - functions to implement importing from other formats
#
#  Written by Curtis Olson.  Started August 25, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: import.pl,v 2.5 1997/04/23 18:07:28 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;   # don't take no guff


# @INC specifies the installed location of the necessary pieces.
# It should already be setup by wrapper.pl

require "common.pl";


# load data from a CBB format file
sub load_cbb {
    # in: file base name
    # out: result

    my($file) = @_;
    $CBB::sorted_keys = 0;
    $CBB::calced = 0;

    open(LOAD, "<$file") || return "error";

    while ( <LOAD> ) {
	if ( m/^\s*#/ ) {
	    # toss the comment (any line whose 1st non-whitespace character is
	    #                   the pound sign.)
	} else {
	    chop;
	    &create_trans($_);
	}
    }

    close(LOAD);

    return "ok";
}


# import a quicken export file (.qif)
sub import_qif {
    # in: file
    # out: result

    my($file) = @_;
    my($date, $check, $desc, $debit, $credit, $cat, $split, $com, $cleared);
    my($amt, $found_split_com);
    my($day, $month, $year);
    my($iend, $incat, $splitsub, $insplit);

    $CBB::sorted_keys = 0;
    $CBB::calced = 0;

    open(QIF, "<$file");

    ($date, $check, $desc, $debit, $credit, $cat, $split, $com, 
    	$cleared) = ("", "", "", "", "", "", "", "", "");

    while ( <QIF> ) {
	chop;			# get rid of that pesky newline.
	# s/:/-/g;		# eliminate our delimiter characters from
	s/\|/-/g;		# the import file.
	s/\r//g;		# strip the dos ^M if needed
	if ( m/^\!/ ) {
	    # Type
	    # print "$_\n";
	} elsif ( m/^D/ ) {
	    # Date
	    ($month, $day, $year) = split(/\/ */, substr($_,1));
	    $month = &pad($month);
	    $day = &pad($day);
	    $date = "$year$month$day";
	    # print "$date\n";
	} elsif ( m/^T/ ) {
	    # Transaction Amount
	    s/,//g;		# remove , from numbers (i.e. thousands)
	    $amt = substr($_,1);
	    if ($amt >= 0) {
		$credit = $amt;
		$debit = 0;
	    } else {
		$debit = substr($amt,1); # remove the '-' to make amt >= 0
		$credit = 0;
	    }
	    # print "credit = $credit  debit = $debit\n";
	} elsif ( m/^C/ ) {
	    # Cleared
	    $cleared = substr($_,1);
	    # print "Cleared = $cleared\n";
	} elsif ( m/^N/ ) {
	    # check Number
	    $check = substr($_,1);
	    # print "Check # = $check\n";
	} elsif ( m/^P/ ) {
	    # descriPtion
	    $desc = substr($_,1);
	    # print "$desc\n";
	} elsif ( m/^L/ ) {
	    # category
	    #
	    # Check for and replace whitespace in account transfer 
	    # categories with underscores. (Cbb equates account "acct"
	    # with account file name "acct.cbb".) B.W.
	    #
	    $cat = substr($_,1);
	    if ( substr($cat,0,1) eq "[" ) {
		$iend = index($cat,"]");
		if ($iend != -1) {
		    $incat = substr($cat,1,$iend - 1);
		    $incat =~ s/\s/_/g;
		    $cat = "[".$incat."]";
		}
	    }
	    #print "Category = $cat\n";
	} elsif ( m/^S/ ) {
	    # split category
	    #
	    # Check for and replace whitespace in account transfer 
	    # categories with underscores. (Cbb equates account "acct"
	    # with account file name "acct.cbb".) B.W.
	    #
	    $splitsub = substr($_,1);
	    if ( substr($splitsub,0,1) eq "[" ) {
		$iend = index($splitsub,"]");
		if ($iend != -1) {
		    $insplit = substr($splitsub,1,$iend - 1);
		    $insplit =~ s/\s/_/g;
		    $splitsub = "[".$insplit."]";
		}
	    }
	    if ($split eq "") {
		# first split
		$split = "|".$splitsub."|";
	    } else {
		# not first split :)
		$split = $split.$splitsub."|";
	    }
	    #print "Split category = $split\n";
	} elsif ( m/^E/ ) {
	    # split comment
	    $split = $split.substr($_,1)."|";
	    $found_split_com = 1;
	} elsif ( m/^\$/ ) {
	    # split amount
	    if ( ! $found_split_com ) {
		$split = $split . "|";
		$found_split_com = 0;
	    }
	    $split = $split.substr($_,1)."|";
	} elsif ( m/^M/ ) {
	    # coMment
	    $com = substr($_,1);
	    #print "Comment = $com\n";
	} elsif ( m/^\^/ ) {
	    #print "End of record\n";
	    if ($split ne "") {
		$cat = $split;
	    }
	    &create_trans(
	    	"$date\t$check\t$desc\t$debit\t$credit\t$cat\t$com\t$cleared\t0.00" );
	    ($date, $check, $desc, $debit, $credit, $cat, $split, $com, 
	    	$cleared) = ("", "", "", "", "", "", "", "", "");
	} elsif ( $_ eq "" ) {
	    # toss empty lines ...
	} else {
	    print "unknown data: $_\n";
	}
    }

    close(QIF);

    return "ok";
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: import.pl,v $
# Revision 2.5  1997/04/23 18:07:28  curt
# Patched these to make importing/exporting more seamless.
#
# Revision 2.4  1997/01/18 03:28:44  curt
# Added "use strict" pragma to enforce good scoping habits.
#
# Revision 2.3  1996/12/17 14:53:58  curt
# Updated copyright date.
#
# Revision 2.2  1996/07/13 02:57:46  curt
# Version 0.65
# Packing Changes
# Documenation changes
# Changes to handle a value in both debit and credit fields.
#
# Revision 2.1  1996/02/27  05:35:44  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:42:58  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
