//===-- llvm/MC/MCXCOFFObjectWriter.h - XCOFF Object Writer ---------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_MC_MCXCOFFOBJECTWRITER_H
#define LLVM_MC_MCXCOFFOBJECTWRITER_H

#include "llvm/MC/MCObjectWriter.h"

namespace llvm {

class raw_pwrite_stream;

class MCXCOFFObjectTargetWriter : public MCObjectTargetWriter {
protected:
  MCXCOFFObjectTargetWriter(bool Is64Bit);

public:
  ~MCXCOFFObjectTargetWriter() override;

  Triple::ObjectFormatType getFormat() const override { return Triple::XCOFF; }
  static bool classof(const MCObjectTargetWriter *W) {
    return W->getFormat() == Triple::XCOFF;
  }
  bool is64Bit() const { return Is64Bit; }

private:
  bool Is64Bit;
};

std::unique_ptr<MCObjectWriter>
createXCOFFObjectWriter(std::unique_ptr<MCXCOFFObjectTargetWriter> MOTW,
                        raw_pwrite_stream &OS);

} // end namespace llvm

#endif // LLVM_MC_MCXCOFFOBJECTWRITER_H
