/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.functionassociation.FunctionAssociationContext;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import resources.ResourceManager;

public class SelectExistingMatchAction
extends DockingAction {
    private static final Icon ICON = ResourceManager.loadImage((String)"images/text_align_justify.png");
    private static final String MENU_GROUP = "Create";
    private final VTController controller;

    public SelectExistingMatchAction(VTController controller) {
        super("Select Exising Match", VTPlugin.OWNER);
        this.controller = controller;
        this.setToolBarData(new ToolBarData(ICON, MENU_GROUP));
        this.setPopupMenuData(new MenuData(new String[]{"Select Existing Match"}, ICON));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Select_Existing_Match"));
    }

    public void actionPerformed(ActionContext context) {
        FunctionAssociationContext providerContext = (FunctionAssociationContext)context;
        VTMatch match = providerContext.getExistingMatch();
        this.controller.setSelectedMatch(match);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof FunctionAssociationContext)) {
            return false;
        }
        FunctionAssociationContext providerContext = (FunctionAssociationContext)context;
        return providerContext.getExistingMatch() != null;
    }

    public boolean isAddToPopup(ActionContext context) {
        return context instanceof FunctionAssociationContext;
    }
}

