/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.impliedmatches;

import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchInfo;

class ImpliedMatchWrapperRowObject
extends VTImpliedMatchInfo {
    private VTMatch existingMatch;

    ImpliedMatchWrapperRowObject(VTImpliedMatchInfo impliedMatch, VTMatch existingMatch) {
        super(impliedMatch.getMatchSet(), impliedMatch.getSourceReference(), impliedMatch.getDestinationReference());
        this.existingMatch = existingMatch;
        this.setAssociationType(impliedMatch.getAssociationType());
        this.setConfidenceScore(impliedMatch.getConfidenceScore());
        this.setSimilarityScore(impliedMatch.getConfidenceScore());
        this.setDestinationAddress(impliedMatch.getDestinationAddress());
        this.setSourceAddress(impliedMatch.getSourceAddress());
        this.setDestinationLength(impliedMatch.getDestinationLength());
        this.setSourceLength(impliedMatch.getSourceLength());
        this.setTag(impliedMatch.getTag());
    }

    void setMatch(VTMatch match) {
        this.existingMatch = match;
    }

    public VTMatch getMatch() {
        return this.existingMatch;
    }

    public boolean isRealMatch() {
        return this.existingMatch != null;
    }

    @Override
    public VTAssociationType getAssociationType() {
        if (this.existingMatch != null) {
            return this.existingMatch.getAssociation().getType();
        }
        return super.getAssociationType();
    }

    @Override
    public VTScore getConfidenceScore() {
        if (this.existingMatch != null) {
            return this.existingMatch.getConfidenceScore();
        }
        return super.getConfidenceScore();
    }

    @Override
    public int getDestinationLength() {
        if (this.existingMatch != null) {
            return this.existingMatch.getDestinationLength();
        }
        return super.getDestinationLength();
    }

    @Override
    public VTMatchSet getMatchSet() {
        if (this.existingMatch != null) {
            return this.existingMatch.getMatchSet();
        }
        return super.getMatchSet();
    }

    @Override
    public VTScore getSimilarityScore() {
        if (this.existingMatch != null) {
            return this.existingMatch.getSimilarityScore();
        }
        return super.getSimilarityScore();
    }

    @Override
    public int getSourceLength() {
        if (this.existingMatch != null) {
            return this.existingMatch.getSourceLength();
        }
        return super.getSourceLength();
    }

    @Override
    public VTMatchTag getTag() {
        if (this.existingMatch != null) {
            return this.existingMatch.getTag();
        }
        return super.getTag();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ImpliedMatchWrapperRowObject other = (ImpliedMatchWrapperRowObject)obj;
        if (this.getSourceReference().equals(other.getSourceReference())) {
            return false;
        }
        if (this.getDestinationReference().equals(other.getDestinationReference())) {
            return false;
        }
        return this.isRealMatch() == other.isRealMatch();
    }
}

