/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class ClearMatchTagTask
extends Task {
    private VTSessionDB sessionDB;
    private List<VTMatch> matches;

    public ClearMatchTagTask(VTSession session, List<VTMatch> matches) {
        super("Clear Match Tag", true, true, true, true);
        this.matches = matches;
        if (!(session instanceof VTSessionDB)) {
            throw new IllegalArgumentException("Unexpected condition - VTSession is not a DB object!");
        }
        this.sessionDB = (VTSessionDB)session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        boolean commit = true;
        int matchSetTransactionID = this.sessionDB.startTransaction(this.getTaskTitle());
        try {
            this.doWork(monitor);
        }
        catch (CancelledException e) {
            commit = false;
        }
        finally {
            this.sessionDB.endTransaction(matchSetTransactionID, commit);
        }
    }

    protected void doWork(TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.matches.size());
        for (VTMatch match : this.matches) {
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            VTMatchTag tag = match.getTag();
            if (tag == VTMatchTag.UNTAGGED) continue;
            match.setTag(VTMatchTag.UNTAGGED);
        }
    }
}

