/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.png;

import ghidra.file.formats.ios.png.CrushedPNGConstants;
import ghidra.file.formats.ios.png.IHDRChunk;
import ghidra.file.formats.ios.png.PNGChunk;
import ghidra.file.formats.ios.png.PNGFormatException;
import ghidra.file.formats.ios.png.ProcessedPNG;
import ghidra.file.formats.zlib.ZLIB;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.compress.utils.IOUtils;

public class CrushedPNGUtil {
    public InputStream getUncrushedPNGBytes(ProcessedPNG png, TaskMonitor monitor) throws Exception {
        int i;
        boolean foundIHDR = false;
        boolean foundIDAT = false;
        boolean foundCgBI = false;
        IHDRChunk ihdrChunk = null;
        byte[] repackArray = null;
        ArrayList<PNGChunk> wantedChunks = new ArrayList<PNGChunk>();
        ByteArrayOutputStream idatStream = new ByteArrayOutputStream();
        for (PNGChunk chunk : png.getChunkArray()) {
            byte[] idBytes = chunk.getChunkIDBytes();
            if (!Arrays.equals(idBytes, CrushedPNGConstants.INSERTED_IOS_CHUNK)) {
                byte[] checksum;
                if (Arrays.equals(idBytes, CrushedPNGConstants.IHDR_CHUNK)) {
                    foundIHDR = true;
                    ihdrChunk = new IHDRChunk(chunk);
                    wantedChunks.add(chunk);
                    checksum = this.calculateCRC32(chunk);
                    if (Arrays.equals(checksum, chunk.getCrc32Bytes())) continue;
                    throw new PNGFormatException("Bad CRC32 on " + chunk.getChunkID() + " chunk");
                }
                if (Arrays.equals(idBytes, CrushedPNGConstants.IDAT_CHUNK)) {
                    idatStream.write(chunk.getData());
                    wantedChunks.add(chunk);
                    foundIDAT = true;
                    checksum = this.calculateCRC32(chunk);
                    if (Arrays.equals(checksum, chunk.getCrc32Bytes())) continue;
                    throw new PNGFormatException("Bad CRC32 on " + chunk.getChunkID() + " chunk");
                }
                wantedChunks.add(chunk);
                checksum = this.calculateCRC32(chunk);
                if (Arrays.equals(checksum, chunk.getCrc32Bytes())) continue;
                throw new PNGFormatException("Bad CRC32 on " + chunk.getChunkID() + " chunk");
            }
            foundCgBI = true;
        }
        if (!foundIHDR) {
            throw new PNGFormatException("Missing IHDR Chunk");
        }
        if (!foundIDAT) {
            throw new PNGFormatException("Missing IDAT chunk(s)");
        }
        if (!foundCgBI) {
            throw new PNGFormatException("Missing CgBI chunk. PNG is not in crushed format");
        }
        if (ihdrChunk == null) {
            throw new PNGFormatException("Invalid IHDRChunk found to be null");
        }
        if (ihdrChunk.getBitDepth() == 8 && ihdrChunk.getColorType() == 2 || ihdrChunk.getColorType() == 6) {
            int expectedSize = ihdrChunk.getBytesPerLine() * ihdrChunk.getImgHeight() + ihdrChunk.getRowFilterBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.getFixedIdatDataBytes(idatStream));
            Object results = new byte[expectedSize];
            Inflater inflater = new Inflater();
            inflater.setInput(IOUtils.toByteArray((InputStream)inputStream));
            int numDecompressed = inflater.inflate((byte[])results);
            if (numDecompressed != expectedSize) {
                throw new PNGFormatException("Decompression Error, expected " + expectedSize + " bytes, but got " + numDecompressed + " bytes");
            }
            this.processIDATChunks(ihdrChunk, (byte[])results);
            byte[] tmp = new byte[65536];
            Deflater deflater = new Deflater();
            deflater.setInput((byte[])results);
            deflater.finish();
            int numCompressed = deflater.deflate(tmp);
            if (numCompressed <= 0) {
                throw new PNGFormatException("Number of compressed bytes <= 0");
            }
            repackArray = new byte[numCompressed];
            for (i = 0; i < numCompressed; ++i) {
                repackArray[i] = tmp[i];
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(CrushedPNGConstants.SIGNATURE_BYTES);
        boolean wroteIDAT = false;
        for (PNGChunk chunk : png.getChunkArray()) {
            byte[] idBytes = chunk.getChunkIDBytes();
            if (Arrays.equals(idBytes, CrushedPNGConstants.INSERTED_IOS_CHUNK)) continue;
            if (Arrays.equals(idBytes, CrushedPNGConstants.IDAT_CHUNK) && !wroteIDAT) {
                int dataLength = repackArray.length;
                byte[] lengthBytes = ByteBuffer.allocate(4).putInt(dataLength).array();
                outputStream.write(lengthBytes);
                byte[] idat = new byte[CrushedPNGConstants.IDAT_CHUNK.length + dataLength];
                for (i = 0; i < CrushedPNGConstants.IDAT_CHUNK.length; ++i) {
                    idat[i] = CrushedPNGConstants.IDAT_CHUNK[i];
                }
                for (i = 0; i < dataLength; ++i) {
                    idat[CrushedPNGConstants.IDAT_CHUNK.length + i] = repackArray[i];
                }
                outputStream.write(idat);
                byte[] checksum = this.calculateCRC32(idat);
                outputStream.write(checksum);
                wroteIDAT = true;
                continue;
            }
            outputStream.write(chunk.getLengthBytes());
            outputStream.write(idBytes);
            outputStream.write(chunk.getData());
            byte[] checksum = this.calculateCRC32(chunk);
            outputStream.write(checksum);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return inputStream;
    }

    private void processIDATChunks(IHDRChunk ihdrChunk, byte[] decompressedResult) throws PNGFormatException {
        if (ihdrChunk.getInterlaceMethod() == 1) {
            int height;
            int width;
            for (int pass = 0; pass < CrushedPNGConstants.STARTING_COL.length; ++pass) {
                width = (ihdrChunk.getImgWidth() - CrushedPNGConstants.STARTING_COL[pass] + CrushedPNGConstants.COL_INCREMENT[pass] - 1) / CrushedPNGConstants.COL_INCREMENT[pass];
                height = (ihdrChunk.getImgHeight() - CrushedPNGConstants.STARTING_ROW[pass] + CrushedPNGConstants.ROW_INCREMENT[pass] - 1) / CrushedPNGConstants.ROW_INCREMENT[pass];
                int y = 0;
                for (int row = 0; row < height; ++row) {
                    if (decompressedResult[y] > 4) {
                        throw new PNGFormatException("Unknown row filter type " + decompressedResult[y]);
                    }
                    ++y;
                    y += width * ihdrChunk.getBytesPerPalette();
                }
            }
            int y = 0;
            for (int pass = 0; pass < CrushedPNGConstants.STARTING_COL.length; ++pass) {
                width = (ihdrChunk.getImgWidth() - CrushedPNGConstants.STARTING_COL[pass] + CrushedPNGConstants.COL_INCREMENT[pass] - 1) / CrushedPNGConstants.COL_INCREMENT[pass];
                height = (ihdrChunk.getImgHeight() - CrushedPNGConstants.STARTING_ROW[pass] + CrushedPNGConstants.ROW_INCREMENT[pass] - 1) / CrushedPNGConstants.ROW_INCREMENT[pass];
                int startAt = y;
                for (int row = 0; row < height; ++row) {
                    ++y;
                    for (int x = 0; x < width; ++x) {
                        byte tmpByte = decompressedResult[y + 2];
                        decompressedResult[y + 2] = decompressedResult[y];
                        decompressedResult[y] = tmpByte;
                        y += ihdrChunk.getBytesPerPalette();
                    }
                }
                if (ihdrChunk.getColorType() != 6) continue;
                this.removeRowFilters(width, height, decompressedResult, startAt);
                this.demultiplyAlpha(width, height, decompressedResult, startAt);
                this.applyRowFilters(width, height, decompressedResult, startAt);
            }
        } else {
            int y;
            for (y = 0; y < ihdrChunk.getBytesPerLine() * ihdrChunk.getImgHeight() + ihdrChunk.getRowFilterBytes(); y += ihdrChunk.getBytesPerLine()) {
                if (decompressedResult[y] > 4) {
                    throw new PNGFormatException("Unkown row filter type " + decompressedResult[y]);
                }
                ++y;
            }
            y = 0;
            while (y < ihdrChunk.getBytesPerLine() * ihdrChunk.getImgHeight() + ihdrChunk.getRowFilterBytes()) {
                ++y;
                for (int x = 0; x < ihdrChunk.getImgWidth(); ++x) {
                    byte tmpByte = decompressedResult[y + 2];
                    decompressedResult[y + 2] = decompressedResult[y];
                    decompressedResult[y] = tmpByte;
                    y += ihdrChunk.getBytesPerPalette();
                }
            }
            if (ihdrChunk.getColorType() == 6) {
                this.removeRowFilters(ihdrChunk.getImgWidth(), ihdrChunk.getImgHeight(), decompressedResult, 0);
                this.demultiplyAlpha(ihdrChunk.getImgWidth(), ihdrChunk.getImgHeight(), decompressedResult, 0);
                this.applyRowFilters(ihdrChunk.getImgWidth(), ihdrChunk.getImgHeight(), decompressedResult, 0);
            }
        }
    }

    private void removeRowFilters(int width, int height, byte[] data, int offset) {
        int x = 0;
        int srcPtr = offset;
        for (int y = 0; y < height; ++y) {
            byte rowFilter = data[srcPtr];
            ++srcPtr;
            switch (rowFilter) {
                case 0: {
                    break;
                }
                case 1: {
                    for (x = 4; x < 4 * width; ++x) {
                        int n = srcPtr + x;
                        data[n] = (byte)(data[n] + data[srcPtr + (x - 4)]);
                    }
                    break;
                }
                case 2: {
                    int upPtr = srcPtr - 4 * width - 1;
                    if (y <= 0) break;
                    for (x = 4; x < 4 * width; ++x) {
                        int n = srcPtr + x;
                        data[n] = (byte)(data[n] + data[upPtr + x]);
                    }
                    break;
                }
                case 3: {
                    int upPtr = srcPtr - 4 * width - 1;
                    if (y == 0) {
                        for (x = 4; x < 4 * width; ++x) {
                            int n = srcPtr + x;
                            data[n] = (byte)(data[n] + (data[upPtr + x] + data[srcPtr + (x - 4)] >> 1));
                        }
                    } else {
                        int n = srcPtr;
                        data[n] = (byte)(data[n] + (data[upPtr + x] >> 1));
                        for (x = 4; x < 4 * width; ++x) {
                            int n2 = srcPtr + x;
                            data[n2] = (byte)(data[n2] + (data[upPtr + x] + data[srcPtr + (x - 4)] >> 1));
                        }
                    }
                    break;
                }
                case 4: {
                    int upPtr = srcPtr - 4 * width - 1;
                    for (x = 0; x < 4 * width; ++x) {
                        int pc;
                        int pb;
                        int p;
                        int pa;
                        int leftPix = 0;
                        int topPix = 0;
                        int topLeftPix = 0;
                        if (x > 0) {
                            leftPix = data[srcPtr + (x - 4)];
                        }
                        if (y > 0) {
                            topPix = data[upPtr + x];
                            if (x >= 4) {
                                topLeftPix = data[upPtr + (x - 4)];
                            }
                        }
                        if ((pa = (p = leftPix + topPix - topLeftPix) - leftPix) < 0) {
                            pa = -pa;
                        }
                        if ((pb = p - topPix) < 0) {
                            pb = -pb;
                        }
                        if ((pc = p - topLeftPix) < 0) {
                            pc = -pc;
                        }
                        int value = pa <= pb && pa <= pc ? leftPix : (pb < pc ? topPix : topLeftPix);
                        int n = srcPtr + x;
                        data[n] = (byte)(data[n] + value);
                    }
                    break;
                }
            }
            srcPtr += 4 * width;
        }
    }

    private void applyRowFilters(int width, int height, byte[] data, int offset) {
        int x = 0;
        int srcPtr = offset;
        block7: for (int y = 0; y < height; ++y) {
            byte rowFilter = data[srcPtr];
            ++srcPtr;
            switch (rowFilter) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    for (x = 4 * width - 1; x >= 4; --x) {
                        int n = srcPtr + x;
                        data[n] = (byte)(data[n] - data[srcPtr + (x - 4)]);
                    }
                    continue block7;
                }
                case 2: {
                    if (y <= 0) continue block7;
                    int upPtr = srcPtr - 1;
                    for (x = 4 * width - 1; x >= 0; --x) {
                        int n = srcPtr + x;
                        data[n] = (byte)(data[n] - data[upPtr + x]);
                    }
                    continue block7;
                }
                case 3: {
                    int upPtr = srcPtr - 4 * width - 1;
                    if (y == 0) {
                        for (x = 4 * width - 1; x >= 4; --x) {
                            int n = srcPtr + x;
                            data[n] = (byte)(data[n] - data[srcPtr + (x - 4) >> 1]);
                        }
                        continue block7;
                    }
                    int n = srcPtr;
                    data[n] = (byte)(data[n] - (data[upPtr + x] >> 1));
                    for (x = 4 * width - 1; x >= 4; --x) {
                        int n2 = srcPtr + x;
                        data[n2] = (byte)(data[n2] - (data[upPtr + x] + data[srcPtr + (x - 4)] >> 1));
                    }
                    continue block7;
                }
                case 4: {
                    int upPtr = srcPtr - 1;
                    for (x = 4 * width - 1; x >= 0; --x) {
                        int pc;
                        int pb;
                        int p;
                        int pa;
                        int leftPix = 0;
                        int topPix = 0;
                        int topLeftPix = 0;
                        if (x > 0) {
                            leftPix = data[srcPtr + (x - 4)];
                        }
                        if (y > 0) {
                            topPix = data[upPtr + x];
                            if (x >= 4) {
                                topLeftPix = data[upPtr + (x - 4)];
                            }
                        }
                        if ((pa = (p = leftPix + topPix - topLeftPix) - leftPix) < 0) {
                            pa = -pa;
                        }
                        if ((pb = p - topPix) < 0) {
                            pb = -pb;
                        }
                        if ((pc = p - topLeftPix) < 0) {
                            pc = -pc;
                        }
                        int value = pa <= pb && pa <= pc ? topPix : topLeftPix;
                        int n = srcPtr + x;
                        data[n] = (byte)(data[n] - value);
                    }
                    continue block7;
                }
            }
        }
    }

    private void demultiplyAlpha(int width, int height, byte[] data, int offset) {
        int srcPtr = offset;
        for (int i = 0; i < height; ++i) {
            ++srcPtr;
            for (int x = 0; x < 4 * width; x += 4) {
                if (data[srcPtr + (x + 3)] <= 0) continue;
                data[srcPtr + x] = (byte)((data[srcPtr + x] * 255 + (data[srcPtr + (x + 3)] >> 1)) / data[srcPtr + (x + 3)]);
                data[srcPtr + (x + 1)] = (byte)((data[srcPtr + (x + 1)] * 255 + (data[srcPtr + (x + 3)] >> 1)) / data[srcPtr + (x + 3)]);
                data[srcPtr + (x + 2)] = (byte)((data[srcPtr + (x + 2)] * 255 + (data[srcPtr + (x + 3)] >> 1)) / data[srcPtr + (x + 3)]);
            }
            srcPtr += 4 * width;
        }
    }

    private byte[] getFixedIdatDataBytes(ByteArrayOutputStream idatChunks) {
        byte[] idatData = idatChunks.toByteArray();
        byte[] fixedIdatData = new byte[idatData.length + 2];
        fixedIdatData[0] = ZLIB.ZLIB_COMPRESSION_DEFAULT[0];
        fixedIdatData[1] = ZLIB.ZLIB_COMPRESSION_DEFAULT[1];
        for (int i = 0; i < idatData.length; ++i) {
            fixedIdatData[i + 2] = idatData[i];
        }
        return fixedIdatData;
    }

    private byte[] calculateCRC32(byte[] data) {
        CRC32 checksum = new CRC32();
        checksum.update(data);
        long result = checksum.getValue();
        return ByteBuffer.allocate(4).putInt((int)result).array();
    }

    private byte[] calculateCRC32(PNGChunk chunk) {
        CRC32 checksum = new CRC32();
        checksum.update(ByteBuffer.allocate(4 + chunk.getLength()).putInt(chunk.getChunkID()).put(chunk.getData()).array());
        long result = checksum.getValue();
        return ByteBuffer.allocate(4).putInt((int)result).array();
    }
}

