/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractBinaryExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.DefaultSolverHint;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.processors.sleigh.expression.RightShiftExpression;
import ghidra.util.Msg;
import java.util.Map;
import java.util.Set;

public class RightShiftExpressionSolver
extends AbstractBinaryExpressionSolver<RightShiftExpression> {
    public RightShiftExpressionSolver() {
        super(RightShiftExpression.class);
    }

    @Override
    public MaskedLong compute(MaskedLong lval, MaskedLong rval) {
        return lval.shiftRight(rval);
    }

    @Override
    public MaskedLong computeLeft(MaskedLong rval, MaskedLong goal) throws SolverException {
        return goal.invShiftRight(rval);
    }

    @Override
    public MaskedLong computeRight(MaskedLong lval, MaskedLong goal) throws SolverException {
        long acc = 0L;
        long bit = 1L;
        for (int i = 0; i < 64; ++i) {
            if (lval.shiftRight(i).agrees(goal)) {
                acc |= bit;
            }
            bit <<= 1;
        }
        if (Long.bitCount(acc) == 1) {
            return MaskedLong.fromLong(Long.numberOfTrailingZeros(acc));
        }
        throw new SolverException("Cannot solve for the right shift amount: " + goal + " = " + lval + " >> R");
    }

    @Override
    protected AssemblyResolution solveTwoSided(RightShiftExpression exp, MaskedLong goal, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur, Set<SolverHint> hints, String description) throws NeedsBackfillException, SolverException {
        if (hints.contains(DefaultSolverHint.GUESSING_RIGHT_SHIFT_AMOUNT)) {
            return super.solveTwoSided(exp, goal, vals, res, cur, hints, description);
        }
        int maxShift = Long.numberOfLeadingZeros(goal.val);
        Set<SolverHint> hintsWithRShift = SolverHint.with(hints, DefaultSolverHint.GUESSING_RIGHT_SHIFT_AMOUNT);
        for (int shift = 0; shift <= maxShift; ++shift) {
            try {
                MaskedLong reqr = MaskedLong.fromLong(shift);
                MaskedLong reql = this.computeLeft(reqr, goal);
                AssemblyResolution lres = this.solver.solve(exp.getLeft(), reql, vals, res, cur, hintsWithRShift, description);
                if (lres.isError()) {
                    throw new SolverException("Solving left failed");
                }
                AssemblyResolution rres = this.solver.solve(exp.getRight(), reqr, vals, res, cur, hints, description);
                if (rres.isError()) {
                    throw new SolverException("Solving right failed");
                }
                AssemblyResolvedConstructor lsol = (AssemblyResolvedConstructor)lres;
                AssemblyResolvedConstructor rsol = (AssemblyResolvedConstructor)rres;
                AssemblyResolvedConstructor sol = lsol.combine(rsol);
                if (sol == null) {
                    throw new SolverException("Left and right solutions conflict for shift=" + shift);
                }
                return sol;
            }
            catch (SolverException | UnsupportedOperationException e) {
                Msg.trace((Object)this, (Object)("Shift of " + shift + " resulted in " + e));
                continue;
            }
        }
        return super.solveTwoSided(exp, goal, vals, res, cur, hints, description);
    }
}

