/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.PseudoCodeUnit;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.UniqueAddressFactory;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionContext;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.OperandType;
import ghidra.program.model.lang.ParserContext;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownContextException;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionPcodeOverride;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.MemReferenceImpl;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;
import java.util.List;

public class PseudoInstruction
extends PseudoCodeUnit
implements Instruction,
InstructionContext {
    private static final Address[] EMPTY_ADDR_ARRAY = new Address[0];
    private AddressFactory addrFactory;
    private InstructionBlock block;
    private InstructionPrototype instrProto;
    private ProcessorContext procContext;
    private ParserContext parserContext;
    private Address fallThroughOverride = null;
    private FlowOverride flowOverride = FlowOverride.NONE;

    public PseudoInstruction(Program program, Address addr, InstructionPrototype prototype, MemBuffer memBuffer, ProcessorContext procContext) throws AddressOverflowException {
        super(program, addr, prototype.getLength(), PseudoInstruction.getByteCacheSize(prototype), memBuffer);
        this.instrProto = prototype;
        this.procContext = procContext;
        if (program != null) {
            this.addrFactory = program.getAddressFactory();
        }
    }

    public PseudoInstruction(AddressFactory addrFactory, Address addr, InstructionPrototype prototype, MemBuffer memBuffer, ProcessorContext procContext) throws AddressOverflowException {
        super(null, addr, prototype.getLength(), PseudoInstruction.getByteCacheSize(prototype), memBuffer);
        this.instrProto = prototype;
        this.procContext = procContext;
        this.addrFactory = addrFactory;
    }

    public PseudoInstruction(Address addr, InstructionPrototype prototype, MemBuffer memBuffer, ProcessorContext procContext) throws AddressOverflowException {
        super(addr, prototype.getLength(), PseudoInstruction.getByteCacheSize(prototype), memBuffer);
        this.instrProto = prototype;
        this.procContext = procContext;
    }

    private static int getByteCacheSize(InstructionPrototype prototype) {
        int length = prototype.getLength();
        int delaySlotByteCount = prototype.getDelaySlotByteCount();
        length = delaySlotByteCount == 1 ? (length += length) : (length += delaySlotByteCount);
        return length + 3;
    }

    public synchronized Byte getRepeatedByte() {
        this.refreshIfNeeded();
        byte b0 = this.bytes[0];
        if (this.length == 1) {
            return b0;
        }
        for (int i = 1; i < this.length; ++i) {
            if (this.bytes[i] == b0) continue;
            return null;
        }
        return b0;
    }

    @Override
    public Register getBaseContextRegister() {
        return this.procContext.getBaseContextRegister();
    }

    @Override
    public Reference[] getOperandReferences(int opIndex) {
        Address toAddr = this.instrProto.getAddress(opIndex, this);
        if (toAddr == null) {
            return emptyMemRefs;
        }
        MemReferenceImpl ref = new MemReferenceImpl(this.address, toAddr, this.getOperandRefType(opIndex), SourceType.DEFAULT, opIndex, false);
        Reference[] refArray = new Reference[]{ref};
        return refArray;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PseudoInstruction cu = (PseudoInstruction)obj;
        if (this.hash != cu.hash) {
            return false;
        }
        if (!this.address.equals(cu.address)) {
            return false;
        }
        return this.instrProto.equals(obj);
    }

    @Override
    public InstructionPrototype getPrototype() {
        return this.instrProto;
    }

    @Override
    public String getMnemonicString() {
        return this.instrProto.getMnemonic(this);
    }

    @Override
    public int getNumOperands() {
        return this.instrProto.getNumOperands();
    }

    @Override
    public Address getAddress(int opIndex) {
        if (opIndex < 0) {
            return null;
        }
        int opType = this.instrProto.getOpType(opIndex, this);
        if (OperandType.isAddress(opType)) {
            return this.instrProto.getAddress(opIndex, this);
        }
        return null;
    }

    @Override
    public Scalar getScalar(int opIndex) {
        if (opIndex < 0) {
            return null;
        }
        return this.instrProto.getScalar(opIndex, this);
    }

    @Override
    public Register getRegister(int opIndex) {
        if (opIndex < 0) {
            return null;
        }
        return this.instrProto.getRegister(opIndex, this);
    }

    @Override
    public Object[] getOpObjects(int opIndex) {
        if (opIndex < 0) {
            return new Object[0];
        }
        return this.instrProto.getOpObjects(opIndex, this);
    }

    @Override
    public Object[] getInputObjects() {
        return this.instrProto.getInputObjects(this);
    }

    @Override
    public Object[] getResultObjects() {
        return this.instrProto.getResultObjects(this);
    }

    @Override
    public String getDefaultOperandRepresentation(int opIndex) {
        List<Object> opList = this.getDefaultOperandRepresentationList(opIndex);
        if (opList == null) {
            return "<UNSUPPORTED>";
        }
        StringBuffer strBuf = new StringBuffer();
        for (Object opElem : opList) {
            if (opElem instanceof Address) {
                Address opAddr = (Address)opElem;
                strBuf.append("0x");
                strBuf.append(opAddr.toString(false));
                continue;
            }
            strBuf.append(opElem.toString());
        }
        return strBuf.toString();
    }

    @Override
    public List<Object> getDefaultOperandRepresentationList(int opIndex) {
        return this.instrProto.getOpRepresentationList(opIndex, this);
    }

    @Override
    public int getOperandType(int opIndex) {
        int optype = this.instrProto.getOpType(opIndex, this);
        return optype;
    }

    @Override
    public RefType getOperandRefType(int opIndex) {
        int opType = this.instrProto.getOpType(opIndex, this);
        if (OperandType.isDataReference(opType)) {
            if (this.getFlowType().isComputed() && OperandType.isIndirect(opType)) {
                return RefType.INDIRECTION;
            }
            return RefType.DATA;
        }
        if (OperandType.isCodeReference(opType)) {
            return this.instrProto.getFlowType(this);
        }
        return RefType.DATA;
    }

    @Override
    public Address getFallThrough() {
        if (this.fallThroughOverride == null) {
            return this.getDefaultFallThrough();
        }
        if (this.fallThroughOverride != Address.NO_ADDRESS) {
            return this.fallThroughOverride;
        }
        return null;
    }

    @Override
    public int getDefaultFallThroughOffset() {
        return this.instrProto.getFallThroughOffset(this);
    }

    @Override
    public Address getDefaultFallThrough() {
        FlowType myFlowType = this.getFlowType();
        if (myFlowType.hasFallthrough()) {
            try {
                return this.address.addNoWrap(this.instrProto.getFallThroughOffset(this));
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Address getFallFrom() {
        throw new UnsupportedOperationException("Not supported by pseduo instruction");
    }

    @Override
    public Address[] getFlows() {
        return this.getDefaultFlows();
    }

    @Override
    public Address[] getDefaultFlows() {
        Address[] flows = this.instrProto.getFlows(this);
        if (this.flowOverride == FlowOverride.RETURN && flows.length == 1) {
            return EMPTY_ADDR_ARRAY;
        }
        return flows;
    }

    @Override
    public FlowType getFlowType() {
        return FlowOverride.getModifiedFlowType(this.instrProto.getFlowType(this), this.flowOverride);
    }

    @Override
    public PcodeOp[] getPcode() {
        return this.instrProto.getPcode(this, null, null);
    }

    @Override
    public PcodeOp[] getPcode(boolean includeOverrides) {
        if (!includeOverrides || this.addrFactory == null) {
            return this.instrProto.getPcode(this, null, null);
        }
        return this.instrProto.getPcode(this, new InstructionPcodeOverride(this), new UniqueAddressFactory(this.addrFactory, this.instrProto.getLanguage()));
    }

    @Override
    public PcodeOp[] getPcode(int opIndex) {
        return this.instrProto.getPcode(this, opIndex);
    }

    @Override
    public int getDelaySlotDepth() {
        return this.instrProto.getDelaySlotDepth(this);
    }

    @Override
    public boolean isInDelaySlot() {
        return this.instrProto.isInDelaySlot();
    }

    @Override
    public Instruction getNext() {
        if (this.program == null) {
            return null;
        }
        return this.program.getListing().getInstructionAfter(this.address);
    }

    @Override
    public Instruction getPrevious() {
        Instruction instr;
        Address addr;
        if (this.block != null && !this.block.getStartAddress().equals(this.address) && (addr = this.address.previous()) != null && (instr = this.block.findFirstIntersectingInstruction(addr, addr)) != null) {
            return instr;
        }
        if (this.program == null) {
            return null;
        }
        return this.program.getListing().getInstructionBefore(this.address);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getMnemonicString());
        int n = this.getNumOperands();
        String sep = this.getSeparator(0);
        if (sep != null || n != 0) {
            stringBuffer.append(' ');
        }
        if (sep != null) {
            stringBuffer.append(sep);
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getDefaultOperandRepresentation(i));
            sep = this.getSeparator(i + 1);
            if (sep == null) continue;
            stringBuffer.append(sep);
        }
        return stringBuffer.toString();
    }

    @Override
    public void clearFallThroughOverride() {
        this.fallThroughOverride = null;
    }

    @Override
    public void setFallThrough(Address addr) {
        this.fallThroughOverride = SystemUtilities.isEqual((Object)addr, (Object)this.getDefaultFallThrough()) ? null : (addr == null ? Address.NO_ADDRESS : addr);
    }

    @Override
    public FlowOverride getFlowOverride() {
        return this.flowOverride;
    }

    @Override
    public void setFlowOverride(FlowOverride flowOverride) {
        this.flowOverride = flowOverride != null ? flowOverride : FlowOverride.NONE;
    }

    @Override
    public boolean isFallThroughOverridden() {
        return this.fallThroughOverride != null;
    }

    @Override
    public boolean hasFallthrough() {
        if (this.isFallThroughOverridden()) {
            return this.getFallThrough() != null;
        }
        return this.getFlowType().hasFallthrough();
    }

    @Override
    public boolean isFallthrough() {
        if (!this.getFlowType().isFallthrough()) {
            return false;
        }
        return this.hasFallthrough();
    }

    @Override
    public String getSeparator(int opIndex) {
        return this.instrProto.getSeparator(opIndex, this);
    }

    @Override
    public boolean hasValue(Register register) {
        return this.procContext.hasValue(register);
    }

    @Override
    public BigInteger getValue(Register register, boolean signed) {
        return this.procContext.getValue(register, signed);
    }

    @Override
    public RegisterValue getRegisterValue(Register register) {
        return this.procContext.getRegisterValue(register);
    }

    @Override
    public Register getRegister(String name) {
        return this.procContext.getRegister(name);
    }

    @Override
    public Register[] getRegisters() {
        return this.procContext.getRegisters();
    }

    @Override
    public void setValue(Register register, BigInteger value) throws ContextChangeException {
        this.procContext.setValue(register, value);
    }

    @Override
    public void setRegisterValue(RegisterValue value) throws ContextChangeException {
        this.procContext.setRegisterValue(value);
    }

    @Override
    public void clearRegister(Register register) throws ContextChangeException {
        this.procContext.clearRegister(register);
    }

    @Override
    public ProcessorContextView getProcessorContext() {
        return this;
    }

    @Override
    public MemBuffer getMemBuffer() {
        return this;
    }

    @Override
    public ParserContext getParserContext() throws MemoryAccessException {
        if (this.parserContext == null) {
            this.parserContext = this.instrProto.getParserContext(this, this);
        }
        return this.parserContext;
    }

    @Override
    public ParserContext getParserContext(Address instructionAddress) throws UnknownContextException, MemoryAccessException {
        if (instructionAddress.equals(this.address)) {
            return this.getParserContext();
        }
        if (this.block == null) {
            try {
                return this.instrProto.getPseudoParserContext(instructionAddress, this.getMemBuffer(), this.procContext);
            }
            catch (InsufficientBytesException e) {
                throw new UnknownContextException("Insufficient bytes when generating pseudo-ParserContext for instruction at: " + instructionAddress);
            }
            catch (UnknownInstructionException e) {
                throw new UnknownContextException("Could not generate pseudo-ParserContext because of unknown instruction at: " + instructionAddress);
            }
        }
        Instruction instr = this.block.getInstructionAt(instructionAddress);
        if (instr instanceof PseudoInstruction) {
            return ((PseudoInstruction)instr).getParserContext();
        }
        if (instr == null) {
            throw new UnknownContextException("Block does not contain cross-build instruction: " + this.getAddress() + " -> " + instructionAddress);
        }
        throw new AssertException("Unexpected instruction class contained within block: " + instr.getClass().getName());
    }

    @Override
    public InstructionContext getInstructionContext() {
        return this;
    }

    public void setInstructionBlock(InstructionBlock bl) {
        this.block = bl;
    }
}

