/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CharsetInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CharsetSettingsDefinition
implements EnumSettingsDefinition {
    private static final String CHARSET_SETTING_NAME = "charset";
    private static final String DEPRECATED_ENCODING_SETTING_NAME = "encoding";
    private static final String DEPRECATED_LANGUAGE_SETTING_NAME = "language";
    private static final String CHARSET_NAME = "Charset";
    public static final CharsetSettingsDefinition CHARSET = new CharsetSettingsDefinition();
    private static Map<Long, List<String>> languageToCharsetIndexMap = new HashMap<Long, List<String>>();
    private final String[] ordinalToString;
    private final Map<String, Integer> stringToOrdinal = new HashMap<String, Integer>();

    private CharsetSettingsDefinition() {
        this.ordinalToString = CharsetInfo.getInstance().getCharsetNames();
        for (int i = 0; i < this.ordinalToString.length; ++i) {
            this.stringToOrdinal.put(this.ordinalToString[i], i);
        }
    }

    public String getCharset(Settings settings, String defaultValue) {
        String cs = settings.getString(CHARSET_SETTING_NAME);
        if (cs == null) {
            cs = this.getDeprecatedEncodingValue(settings);
        }
        return cs != null ? cs : defaultValue;
    }

    private String getDeprecatedEncodingValue(Settings settings) {
        Long langIndex = settings.getLong(DEPRECATED_LANGUAGE_SETTING_NAME);
        Long encodingIndex = settings.getLong(DEPRECATED_ENCODING_SETTING_NAME);
        if (langIndex == null || encodingIndex == null) {
            return null;
        }
        List<String> encodings = languageToCharsetIndexMap.get(langIndex);
        return encodings != null && encodingIndex >= 0L && encodingIndex < (long)encodings.size() ? encodings.get(encodingIndex.intValue()) : null;
    }

    public void setCharset(Settings settings, String charset) {
        if (charset == null || charset.isEmpty()) {
            settings.clearSetting(CHARSET_SETTING_NAME);
        } else {
            settings.setString(CHARSET_SETTING_NAME, charset);
        }
        settings.clearSetting(DEPRECATED_ENCODING_SETTING_NAME);
        settings.clearSetting(DEPRECATED_LANGUAGE_SETTING_NAME);
    }

    public int getChoice(Settings settings) {
        return this.stringToOrdinal.getOrDefault(this.getCharset(settings, null), 0);
    }

    public void setChoice(Settings settings, int ordinalOfValue) {
        if (ordinalOfValue < 0 || ordinalOfValue >= this.ordinalToString.length) {
            settings.clearSetting(CHARSET_SETTING_NAME);
        } else {
            settings.setString(CHARSET_SETTING_NAME, this.ordinalToString[ordinalOfValue]);
        }
        settings.clearSetting(DEPRECATED_ENCODING_SETTING_NAME);
        settings.clearSetting(DEPRECATED_LANGUAGE_SETTING_NAME);
    }

    public String[] getDisplayChoices(Settings settings) {
        return this.ordinalToString;
    }

    public String getName() {
        return CHARSET_NAME;
    }

    public String getDescription() {
        return "Character set";
    }

    public String getDisplayChoice(int ordinalOfValue, Settings s1) {
        return this.ordinalToString[ordinalOfValue];
    }

    public void clear(Settings settings) {
        settings.clearSetting(CHARSET_SETTING_NAME);
    }

    public void copySetting(Settings settings, Settings destSettings) {
        String s = settings.getString(CHARSET_SETTING_NAME);
        if (s == null) {
            destSettings.clearSetting(CHARSET_SETTING_NAME);
        } else {
            destSettings.setString(CHARSET_SETTING_NAME, s);
        }
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(CHARSET_SETTING_NAME) != null || setting.getValue(DEPRECATED_ENCODING_SETTING_NAME) != null;
    }

    public static void setStaticEncodingMappingValues(Map<Long, List<String>> mappingValues) {
        languageToCharsetIndexMap.clear();
        languageToCharsetIndexMap.putAll(mappingValues);
    }
}

