/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.GhidraBigEndianDataConverter;
import ghidra.util.GhidraLittleEndianDataConverter;
import java.math.BigInteger;

public class ByteMemBufferImpl
implements MemBuffer {
    private byte[] bytes;
    private Address addr;
    private final boolean isBigEndian;

    public ByteMemBufferImpl(Address addr, byte[] bytes, boolean isBigEndian) {
        this.addr = addr;
        this.bytes = bytes;
        this.isBigEndian = isBigEndian;
    }

    public ByteMemBufferImpl(Address addr, boolean isBigEndian, int ... byteValues) {
        this.addr = addr;
        this.isBigEndian = isBigEndian;
        this.bytes = new byte[byteValues.length];
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = (byte)byteValues[i];
        }
    }

    public int getLength() {
        return this.bytes.length;
    }

    @Override
    public Address getAddress() {
        return this.addr;
    }

    @Override
    public byte getByte(int offset) throws MemoryAccessException {
        if (offset < 0 || offset >= this.bytes.length) {
            throw new MemoryAccessException("Offset " + offset + " is not in range");
        }
        return this.bytes[offset];
    }

    @Override
    public Memory getMemory() {
        throw new UnsupportedOperationException("Can't get memory from ByteMemBuffer");
    }

    @Override
    public int getBytes(byte[] b, int offset) {
        if (offset < 0 || offset >= this.bytes.length) {
            return 0;
        }
        int len = Math.min(b.length, this.bytes.length - offset);
        System.arraycopy(this.bytes, offset, b, 0, len);
        return len;
    }

    @Override
    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    @Override
    public short getShort(int offset) throws MemoryAccessException {
        if (this.isBigEndian) {
            return GhidraBigEndianDataConverter.INSTANCE.getShort(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getShort(this, offset);
    }

    @Override
    public int getInt(int offset) throws MemoryAccessException {
        if (this.isBigEndian) {
            return GhidraBigEndianDataConverter.INSTANCE.getInt(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getInt(this, offset);
    }

    @Override
    public long getLong(int offset) throws MemoryAccessException {
        if (this.isBigEndian) {
            return GhidraBigEndianDataConverter.INSTANCE.getLong(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getLong(this, offset);
    }

    @Override
    public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        if (this.isBigEndian) {
            return GhidraBigEndianDataConverter.INSTANCE.getBigInteger(this, offset, size, signed);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getBigInteger(this, offset, size, signed);
    }
}

