/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import java.math.BigInteger;

public interface MemBuffer {
    default public boolean isInitializedMemory() {
        try {
            this.getByte(0);
            return true;
        }
        catch (MemoryAccessException memoryAccessException) {
            return false;
        }
    }

    public byte getByte(int var1) throws MemoryAccessException;

    default public int getUnsignedByte(int offset) throws MemoryAccessException {
        return this.getByte(offset) & 0xFF;
    }

    public int getBytes(byte[] var1, int var2);

    public Address getAddress();

    public Memory getMemory();

    public boolean isBigEndian();

    public short getShort(int var1) throws MemoryAccessException;

    default public int getUnsignedShort(int offset) throws MemoryAccessException {
        return this.getShort(offset) & 0xFFFF;
    }

    public int getInt(int var1) throws MemoryAccessException;

    default public long getUnsignedInt(int offset) throws MemoryAccessException {
        return (long)this.getInt(offset) & 0xFFFFFFFFL;
    }

    public long getLong(int var1) throws MemoryAccessException;

    public BigInteger getBigInteger(int var1, int var2, boolean var3) throws MemoryAccessException;

    default public int getVarLengthInt(int offset, int len) throws MemoryAccessException {
        switch (len) {
            case 1: {
                return this.getByte(offset);
            }
            case 2: {
                return this.getShort(offset);
            }
            case 4: {
                return this.getInt(offset);
            }
        }
        throw new MemoryAccessException("Invalid length for read: " + len);
    }

    default public long getVarLengthUnsignedInt(int offset, int len) throws MemoryAccessException {
        switch (len) {
            case 1: {
                return this.getUnsignedByte(offset);
            }
            case 2: {
                return this.getUnsignedShort(offset);
            }
            case 4: {
                return this.getUnsignedInt(offset);
            }
        }
        throw new MemoryAccessException("Invalid length for read: " + len);
    }
}

