/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.events;

import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import java.lang.ref.WeakReference;

public final class ProgramLocationPluginEvent
extends PluginEvent {
    public static final String NAME = "ProgramLocationChange";
    private ProgramLocation loc;
    private WeakReference<Program> programRef;

    public ProgramLocationPluginEvent(String src, ProgramLocation loc, Program program) {
        super(src, NAME);
        if (loc == null) {
            NullPointerException exc = new NullPointerException("Null ProgramLocation passed to create a Plugin event");
            Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Null ProgramLocationEvent being created.  Trace and remove this problem", (Throwable)exc);
        }
        this.loc = loc;
        this.programRef = new WeakReference<Program>(program);
    }

    public ProgramLocation getLocation() {
        return this.loc;
    }

    public Program getProgram() {
        return (Program)this.programRef.get();
    }

    protected String getDetails() {
        if (this.loc != null) {
            return this.loc.getClass().getName() + " addr==> " + this.loc.getAddress() + "\n";
        }
        return super.getDetails();
    }
}

