/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.events;

import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import java.lang.ref.WeakReference;

public final class ProgramSelectionPluginEvent
extends PluginEvent {
    public static final String NAME = "ProgramSelection";
    private ProgramSelection selection;
    private WeakReference<Program> programRef;

    public ProgramSelectionPluginEvent(String src, ProgramSelection sel, Program program) {
        super(src, NAME);
        if (sel == null) {
            NullPointerException exc = new NullPointerException("Null ProgramSelection in creating Selection Plugin Event");
            Msg.showError((Object)((Object)this), null, (String)"Internal Error", (Object)"Null ProgramSelectionEvent being created.  Trace and remove this problem", (Throwable)exc);
        }
        this.selection = sel;
        this.programRef = new WeakReference<Program>(program);
    }

    public ProgramSelection getSelection() {
        return this.selection;
    }

    public Program getProgram() {
        return (Program)this.programRef.get();
    }

    protected String getDetails() {
        return "Address Set ==> " + this.selection;
    }
}

