/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.analysis.AnalysisPanel;
import ghidra.framework.options.EditorStateFactory;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

public class AnalysisOptionsDialog
extends DialogComponentProvider
implements PropertyChangeListener {
    private boolean doAnalysis;
    private AnalysisPanel panel;
    private EditorStateFactory editorStateFactory = new EditorStateFactory();

    AnalysisOptionsDialog(Program program) {
        this(List.of(program));
    }

    AnalysisOptionsDialog(List<Program> programs) {
        super("Analysis Options");
        this.setHelpLocation(new HelpLocation("AutoAnalysisPlugin", "AnalysisOptions"));
        this.panel = this.buildComponent(programs);
        this.addWorkPanel(this.panel);
        this.addOKButton();
        this.addCancelButton();
        this.setOkButtonText("Analyze");
        this.okButton.setMnemonic('A');
        this.setOkEnabled(true);
        this.setPreferredSize(800, 400);
        this.setRememberSize(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.panel != null) {
            this.panel.updateOptionForAllPrograms(evt.getPropertyName(), (Boolean)evt.getNewValue());
        }
    }

    public void okCallback() {
        try {
            this.panel.applyChanges();
            this.doAnalysis = true;
            this.close();
        }
        catch (Exception e) {
            Msg.showError((Object)this, (Component)this.panel, (String)"Error Setting Analysis Options", (Object)e.getMessage(), (Throwable)e);
        }
    }

    boolean wasAnalyzeButtonSelected() {
        return this.doAnalysis;
    }

    private AnalysisPanel buildComponent(List<Program> programs) {
        AnalysisPanel panel = new AnalysisPanel(programs, this.editorStateFactory, (PropertyChangeListener)this);
        return panel;
    }
}

