/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.util.exception.UsrException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class InsertUndefinedAction
extends CompositeEditorTableAction {
    private static final ImageIcon insertUndefinedIcon = ResourceManager.loadImage((String)"images/Plus.png");
    private static final String ACTION_NAME = "Insert Undefined Byte";
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Insert an undefined byte before the selection";
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(85, 8);
    private static String[] popupPath = new String[]{"Insert Undefined Byte"};

    public InsertUndefinedAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Insert Undefined Byte", GROUP_NAME, popupPath, null, insertUndefinedIcon);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        try {
            int index;
            boolean isContiguousSelection;
            boolean bl = isContiguousSelection = this.model.getSelection().getNumRanges() == 1;
            if (isContiguousSelection && (index = this.model.getMinIndexSelected()) >= 0) {
                Undefined1DataType undefinedDt = this.model.viewComposite.isInternallyAligned() ? Undefined1DataType.dataType : DataType.DEFAULT;
                DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)undefinedDt, (int)-1);
                this.model.insert(index, dti.getDataType(), dti.getLength());
            }
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage());
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        boolean enabled = false;
        if (this.model.viewComposite instanceof Structure) {
            boolean isContiguousSelection = this.model.getSelection().getNumRanges() == 1;
            Undefined1DataType undefinedDt = this.model.viewComposite.isInternallyAligned() ? Undefined1DataType.dataType : DataType.DEFAULT;
            enabled = isContiguousSelection && this.model.isInsertAllowed(this.model.getMinIndexSelected(), (DataType)undefinedDt);
        }
        this.setEnabled(enabled);
    }
}

