/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.model;

import ghidra.app.plugin.core.instructionsearch.util.InstructionSearchUtils;
import ghidra.util.exception.InvalidInputException;

public class MaskContainer {
    private byte[] mask;
    private byte[] value;

    public MaskContainer(byte[] mask, byte[] value) throws IllegalArgumentException {
        if (mask == null || value == null) {
            throw new IllegalArgumentException("Mask container initialization error: mask and/or value arrays cannot be null");
        }
        if (mask.length != value.length) {
            throw new IllegalArgumentException("Mask container initialization error: mask/value arrays must be the same size");
        }
        this.mask = mask;
        this.value = value;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public String getMaskAsBinaryString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.mask.length; ++i) {
            str.append(InstructionSearchUtils.toBinaryString(this.mask[i]));
        }
        return str.toString();
    }

    public void setMask(byte[] mask) {
        this.mask = mask;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getValueAsBinaryString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.value.length; ++i) {
            str.append(InstructionSearchUtils.toBinaryString(this.value[i]));
        }
        return str.toString();
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public String toBinaryString() {
        int i;
        StringBuilder valueString = new StringBuilder();
        StringBuilder maskString = new StringBuilder();
        for (i = 0; i < this.value.length; ++i) {
            valueString.append(InstructionSearchUtils.toBinaryString(this.value[i]));
        }
        for (i = 0; i < this.mask.length; ++i) {
            maskString.append(InstructionSearchUtils.toBinaryString(this.mask[i]));
        }
        String combinedString = "";
        try {
            combinedString = InstructionSearchUtils.formatSearchString(valueString.toString(), maskString.toString());
        }
        catch (InvalidInputException e) {
            e.printStackTrace();
        }
        return combinedString;
    }
}

