/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ClampPropertiesLookup {
    public static final String CLAMP_PROPERTIES_FILENAME = "formats/clamp.properties";
    private static boolean UNINITIALIZED = true;
    private static Properties properties = null;

    public static long getClampValue(String clampKey, long defaultValue) {
        ClampPropertiesLookup.initialize();
        try {
            String property = properties.getProperty(clampKey);
            if (property != null) {
                try {
                    long value = Long.parseLong(property);
                    return value;
                }
                catch (NumberFormatException e) {
                    return defaultValue;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return defaultValue;
    }

    private static synchronized void initialize() {
        if (UNINITIALIZED) {
            InputStream inputStream = null;
            try {
                ResourceFile propertiesFile = Application.getModuleDataFile((String)CLAMP_PROPERTIES_FILENAME);
                properties = new Properties();
                inputStream = propertiesFile.getInputStream();
                properties.load(inputStream);
            }
            catch (FileNotFoundException e) {
                Msg.warn(ClampPropertiesLookup.class, (Object)"couldn't find clamp properties file");
            }
            catch (IOException e) {
                Msg.warn(ClampPropertiesLookup.class, (Object)"IOException reading clamp properties file", (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            UNINITIALIZED = false;
        }
    }
}

