/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho;

import java.lang.reflect.Field;

public final class SectionTypes {
    public static final int SECTION_TYPE_MASK = 255;
    public static final int S_REGULAR = 0;
    public static final int S_ZEROFILL = 1;
    public static final int S_CSTRING_LITERALS = 2;
    public static final int S_4BYTE_LITERALS = 3;
    public static final int S_8BYTE_LITERALS = 4;
    public static final int S_LITERAL_POINTERS = 5;
    public static final int S_NON_LAZY_SYMBOL_POINTERS = 6;
    public static final int S_LAZY_SYMBOL_POINTERS = 7;
    public static final int S_SYMBOL_STUBS = 8;
    public static final int S_MOD_INIT_FUNC_POINTERS = 9;
    public static final int S_MOD_TERM_FUNC_POINTERS = 10;
    public static final int S_COALESCED = 11;
    public static final int S_GB_ZEROFILL = 12;
    public static final int S_INTERPOSING = 13;
    public static final int S_16BYTE_LITERALS = 14;
    public static final int S_DTRACE_DOF = 15;
    public static final int S_LAZY_DYLIB_SYMBOL_POINTERS = 16;
    public static final int S_THREAD_LOCAL_REGULAR = 17;
    public static final int S_THREAD_LOCAL_ZEROFILL = 18;
    public static final int S_THREAD_LOCAL_VARIABLES = 19;
    public static final int S_THREAD_LOCAL_VARIABLE_POINTERS = 20;
    public static final int S_THREAD_LOCAL_INIT_FUNCTION_POINTERS = 21;

    public static final String getTypeName(int type) {
        Field[] fields;
        for (Field field : fields = SectionTypes.class.getDeclaredFields()) {
            if (!field.getName().startsWith("S_")) continue;
            try {
                Integer value = (Integer)field.get(null);
                if (value != type) continue;
                return field.getName().substring("S_".length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "Unrecognized_Section_Type_0x" + Integer.toHexString(type);
    }
}

