/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_ImageInfo
implements StructConverter {
    public static final int OBJC_IMAGE_IS_REPLACEMENT = 1;
    public static final int OBJC_IMAGE_SUPPORTS_GC = 2;
    public static final int OBJC_IMAGE_REQUIRES_GC = 4;
    private ObjectiveC2_State _state;
    private long _index;
    private int version;
    private int flags;

    public ObjectiveC2_ImageInfo(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        this.version = reader.readNextInt();
        this.flags = reader.readNextInt();
    }

    public int getVersion() {
        return this.version;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isReplacement() {
        return (this.flags & 1) != 0;
    }

    public boolean isSupportsGarbageCollection() {
        return (this.flags & 2) != 0;
    }

    public boolean isRequiresGarbageCollection() {
        return (this.flags & 4) != 0;
    }

    public long getIndex() {
        return this._index;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_image_info", 0);
        struct.add(DWORD, "version", null);
        struct.add(DWORD, "flags", null);
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    public void applyTo() throws Exception {
        Address address = ObjectiveC1_Utilities.toAddress(this._state.program, this.getIndex());
        try {
            ObjectiveC1_Utilities.applyData(this._state.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

