/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTypeIdUrl {
    private static String PROTOCOL = "datatype";
    private static Pattern URL_PATTERN = Pattern.compile(PROTOCOL + ":/(\\d+)/(\\d+)");
    private UniversalID dataTypeManagerId;
    private UniversalID dataTypeId;

    public DataTypeIdUrl(DataType dt) {
        DataTypeManager dtm = dt.getDataTypeManager();
        if (dtm == null) {
            Msg.debug((Object)this, (Object)"");
        }
        this.dataTypeManagerId = dtm.getUniversalID();
        this.dataTypeId = dt.getUniversalID();
    }

    public DataTypeIdUrl(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid data type URL '" + url + "'");
        }
        String dtmId = matcher.group(1);
        String dtId = matcher.group(2);
        this.dataTypeManagerId = new UniversalID(Long.parseLong(dtmId));
        this.dataTypeId = new UniversalID(Long.parseLong(dtId));
    }

    public UniversalID getDataTypeManagerId() {
        return this.dataTypeManagerId;
    }

    public UniversalID getDataTypeId() {
        return this.dataTypeId;
    }

    public String toString() {
        return PROTOCOL + ":/" + this.dataTypeManagerId.toString() + "/" + this.dataTypeId.toString();
    }
}

