/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public interface Loader
extends ExtensionPoint,
Comparable<Loader> {
    public static final String COMMAND_LINE_ARG_PREFIX = "-loader";

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider var1) throws IOException;

    public List<DomainObject> load(ByteProvider var1, String var2, DomainFolder var3, LoadSpec var4, List<Option> var5, MessageLog var6, Object var7, TaskMonitor var8) throws IOException, CancelledException, DuplicateNameException, InvalidNameException, VersionException;

    public boolean loadInto(ByteProvider var1, LoadSpec var2, List<Option> var3, MessageLog var4, Program var5, TaskMonitor var6) throws IOException, CancelledException;

    public List<Option> getDefaultOptions(ByteProvider var1, LoadSpec var2, DomainObject var3, boolean var4);

    public String validateOptions(ByteProvider var1, LoadSpec var2, List<Option> var3, Program var4);

    public String getName();

    public LoaderTier getTier();

    public int getTierPriority();

    default public String getPreferredFileName(ByteProvider provider) {
        return provider.getName().replaceAll("[\\\\:|]+", "/");
    }

    default public boolean supportsLoadIntoProgram() {
        return false;
    }

    @Override
    default public int compareTo(Loader o) {
        int compareTiers = this.getTier().compareTo(o.getTier());
        if (compareTiers == 0) {
            int comparePriorities = this.getTierPriority() - o.getTierPriority();
            if (comparePriorities == 0) {
                return this.getName().compareTo(o.getName());
            }
            return comparePriorities;
        }
        return compareTiers;
    }
}

