/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.SpaceFieldLocation;
import ghidra.util.exception.NoValueException;
import java.awt.Color;
import java.math.BigInteger;

public class SpaceFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Space";

    public SpaceFieldFactory() {
        super(FIELD_NAME);
    }

    private SpaceFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        if (cu.hasProperty(FIELD_NAME)) {
            try {
                int n = cu.getIntProperty(FIELD_NAME);
                if (n == 0) {
                    cu.removeProperty(FIELD_NAME);
                    return null;
                }
                if (n < 0) {
                    n = -n;
                }
                FieldElement[] fes = new FieldElement[n];
                AttributedString as = new AttributedString("", Color.BLACK, this.getMetrics());
                for (int i = 0; i < n; ++i) {
                    fes[i] = new TextFieldElement(as, 0, 0);
                }
                return ListingTextField.createMultilineTextField(this, proxy, fes, this.startX + varWidth, this.width, n + 1, this.hlProvider);
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        int[] cpath = null;
        if (obj instanceof Data) {
            cpath = ((Data)obj).getComponentPath();
        }
        return new SpaceFieldLocation(cu.getProgram(), cu.getMinAddress(), null, cpath, row);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (programLoc instanceof SpaceFieldLocation) {
            SpaceFieldLocation loc = (SpaceFieldLocation)programLoc;
            return new FieldLocation(index, fieldNum, loc.getRow(), 0);
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new SpaceFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }
}

