/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis;

import generic.jar.ResourceFile;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.framework.analysis.AnalysisPhase;
import ghidra.framework.analysis.AnalyzerInfo;
import ghidra.framework.analysis.GhidraScriptAnalyzerAdapter;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.jdom.Content;
import org.jdom.Element;

public class AnalysisRecipe {
    private List<AnalysisPhase> phases = new ArrayList<AnalysisPhase>();
    private Map<Analyzer, AnalyzerInfo> analyzerMap = new HashMap<Analyzer, AnalyzerInfo>();
    private List<AnalyzerInfo> analyzerInfoList = new ArrayList<AnalyzerInfo>();
    private ToolOptions options = new ToolOptions("Analysis Options");
    private String name;
    private ChangeListener listener;

    public AnalysisRecipe(String name, Collection<Analyzer> analyzers, Program program) {
        this.name = name;
        this.phases.add(new AnalysisPhase(this, 0, true));
        for (Analyzer analyzer : analyzers) {
            if (!analyzer.canAnalyze(program)) continue;
            boolean defaultEnablement = analyzer.getDefaultEnablement(program);
            AnalyzerInfo info = new AnalyzerInfo(this, analyzer, defaultEnablement);
            this.analyzerMap.put(analyzer, info);
            this.analyzerInfoList.add(info);
        }
        Collections.sort(this.analyzerInfoList);
        for (Analyzer analyzer : analyzers) {
            analyzer.registerOptions(this.options.getOptions(analyzer.getName()), program);
        }
    }

    public Options getOptions(Analyzer analyzer) {
        return this.options.getOptions(analyzer.getName());
    }

    public String getName() {
        return this.name;
    }

    Element toXML() {
        Element root = new Element("Analysis_Recipe");
        root.setAttribute("Name", this.name);
        for (AnalysisPhase phase : this.phases) {
            root.addContent((Content)phase.toXML());
        }
        for (AnalyzerInfo info : this.analyzerMap.values()) {
            root.addContent((Content)info.toXML());
        }
        Element optionsElement = this.options.getXmlRoot(false);
        root.addContent((Content)optionsElement);
        return root;
    }

    void loadFromXML(Element root) {
        this.phases.clear();
        this.name = root.getAttributeValue("Name");
        List phaseChildren = root.getChildren("ANALYSIS_PHASE");
        for (Object object : phaseChildren) {
            Element child = (Element)object;
            this.phases.add(new AnalysisPhase(child));
        }
        Collections.sort(this.phases);
        List infoChildren = root.getChildren("ANALYZER");
        for (Object object : infoChildren) {
            this.processAnalyzerInfoElement((Element)object);
        }
        Element optionsElement = root.getChild("CATEGORY");
        this.options = new ToolOptions(optionsElement);
    }

    private void processAnalyzerInfoElement(Element element) {
        AnalyzerInfo info;
        String className = element.getAttributeValue("CLASS_NAME");
        if (GhidraScriptAnalyzerAdapter.class.getName().equals(className)) {
            info = AnalyzerInfo.createInfoForWrappedAnalzyer(this, element);
            info.setStartPhase(this.getFirstPhase());
            this.analyzerMap.put(info.getAnalyzer(), info);
            this.analyzerInfoList.add(info);
            Collections.sort(this.analyzerInfoList);
        }
        if ((info = this.findInfoForAnalyzerClass(className)) != null) {
            info.loadFromXML(element);
        }
    }

    private AnalyzerInfo findInfoForAnalyzerClass(String className) {
        for (AnalyzerInfo info : this.analyzerInfoList) {
            if (!className.equals(info.getAnalyzer().getClass().getName())) continue;
            return info;
        }
        return null;
    }

    public List<AnalysisPhase> getAnalysisPhases() {
        return this.phases;
    }

    public AnalysisPhase getLastPhase() {
        return this.phases.get(this.phases.size() - 1);
    }

    public AnalysisPhase getFirstPhase() {
        return this.phases.get(0);
    }

    public AnalysisPhase createPhase() {
        AnalysisPhase newPhase = new AnalysisPhase(this, 0, false);
        this.phases.add(0, newPhase);
        for (int i = 0; i < this.phases.size(); ++i) {
            this.phases.get(i).setIndex(i);
        }
        this.notifyChanged();
        return newPhase;
    }

    public void deletePhase() {
        if (this.phases.size() <= 1) {
            return;
        }
        AnalysisPhase removedPhase = this.phases.remove(0);
        AnalysisPhase firstPhase = this.phases.get(0);
        for (int i = 0; i < this.phases.size(); ++i) {
            this.phases.get(i).setIndex(i);
        }
        for (AnalyzerInfo info : this.analyzerInfoList) {
            if (info.getAnalyzerStartPhase() != removedPhase) continue;
            info.setStartPhase(firstPhase);
        }
        this.notifyChanged();
    }

    public List<Analyzer> getAnalyzers() {
        ArrayList<Analyzer> list = new ArrayList<Analyzer>(this.analyzerMap.size());
        for (AnalyzerInfo info : this.analyzerInfoList) {
            list.add(info.getAnalyzer());
        }
        return list;
    }

    public AnalysisPhase getPhase(int i) {
        return this.phases.get(i);
    }

    public boolean isAnalyzerEnabled(Analyzer analyzer) {
        AnalyzerInfo analyzerInfo = this.analyzerMap.get(analyzer);
        return analyzerInfo.isEnabled();
    }

    public AnalysisPhase getExecutionPhase(Analyzer analyzer, AnalysisPhase currentPhase) {
        AnalyzerInfo analyzerInfo = this.analyzerMap.get(analyzer);
        return analyzerInfo.getNextEnabledPhaseAtOrAfter(currentPhase);
    }

    private void notifyChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    public void setAnalyzerEnablement(Analyzer analyzer, boolean b) {
        AnalyzerInfo info = this.analyzerMap.get(analyzer);
        info.setEnabled(b);
        this.notifyChanged();
    }

    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    public List<Analyzer> getAnalyzers(AnalysisPhase phase) {
        if (phase == null) {
            return this.getAnalyzers();
        }
        ArrayList<Analyzer> list = new ArrayList<Analyzer>();
        for (AnalyzerInfo info : this.analyzerInfoList) {
            if (info.getNextEnabledPhaseAtOrAfter(phase) != phase) continue;
            list.add(info.getAnalyzer());
        }
        return list;
    }

    public void setAnalyzerStartPhase(Analyzer analyzer, AnalysisPhase phase) {
        AnalyzerInfo info = this.analyzerMap.get(analyzer);
        info.setStartPhase(phase);
        this.notifyChanged();
    }

    public AnalysisPhase getAnalyzerStartPhase(Analyzer analyzer) {
        AnalyzerInfo info = this.analyzerMap.get(analyzer);
        return info.getAnalyzerStartPhase();
    }

    public void addScriptAnalyzer(ResourceFile file, AnalyzerType analyzerType, int priority) {
        GhidraScriptAnalyzerAdapter analyzer = new GhidraScriptAnalyzerAdapter(file, analyzerType, priority);
        AnalyzerInfo info = new AnalyzerInfo(this, analyzer, true);
        info.setStartPhase(this.getFirstPhase());
        this.analyzerMap.put(analyzer, info);
        this.analyzerInfoList.add(info);
        Collections.sort(this.analyzerInfoList);
        this.notifyChanged();
    }

    public void deleteScriptAnalyzer(Analyzer analyzer) {
        AnalyzerInfo removedInfo = this.analyzerMap.remove(analyzer);
        if (removedInfo != null) {
            this.analyzerInfoList.remove(removedInfo);
        }
        this.notifyChanged();
    }
}

