/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util.string;

import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.util.string.AbstractStringSearcher;
import ghidra.program.util.string.FoundStringCallback;
import ghidra.program.util.string.PascalUtil;
import ghidra.util.ascii.AsciiCharSetRecognizer;
import ghidra.util.ascii.CharSetRecognizer;
import ghidra.util.ascii.Sequence;

public class PascalStringSearcher
extends AbstractStringSearcher {
    public PascalStringSearcher(Program program, int minimumStringSize, int alignment, boolean includePascalUnicode) {
        super(program, new AsciiCharSetRecognizer(), minimumStringSize, alignment, true, PascalStringSearcher.checkForWideChar(program), false);
    }

    public PascalStringSearcher(Program program, CharSetRecognizer charSet, int minimumStringSize, int alignment, boolean includePascalUnicode) {
        super(program, charSet, minimumStringSize, alignment, true, PascalStringSearcher.checkForWideChar(program), false);
    }

    private static boolean checkForWideChar(Program program) {
        int wideCharSize = program.getDataTypeManager().getDataOrganization().getWideCharSize();
        return wideCharSize == 2;
    }

    @Override
    protected void processSequence(FoundStringCallback callback, Sequence sequence, MemBuffer buf) {
        Sequence pascalSequence = PascalUtil.findPascalSequence(buf, sequence, this.getAlignment());
        if (pascalSequence != null) {
            callback.stringFound(this.getFoundString(buf, pascalSequence, (DataType)pascalSequence.getStringDataType()));
        }
    }
}

