/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb.DefaultCompositeMember;
import ghidra.app.util.bin.format.pdb.PdbKind;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.bin.format.pdb.PdbUtil;
import ghidra.app.util.importer.MessageLog;
import ghidra.graph.DefaultGEdge;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.algo.GraphNavigator;
import ghidra.graph.jung.JungDirectedGraph;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.SAXParseException;

public class ApplyDataTypes {
    private PdbParser pdbParser;
    private MessageLog log;
    private HashMap<String, CompositeDefinition> compositeQueue = new HashMap();

    ApplyDataTypes(PdbParser pdbParser, MessageLog log) throws CancelledException, SAXParseException {
        this.pdbParser = pdbParser;
        this.log = log;
    }

    void dispose() {
        this.compositeQueue.clear();
    }

    private List<CompositeDefinition> getCompositeDefinitionsInPostDependencyOrder(TaskMonitor monitor) {
        JungDirectedGraph graph = new JungDirectedGraph();
        for (CompositeDefinition compositeDefinition : this.compositeQueue.values()) {
            graph.addVertex((Object)compositeDefinition);
            for (PdbMember pdbMember : compositeDefinition.memberList) {
                CompositeDefinition child;
                String name = pdbMember.memberDataTypeName;
                int index = name.indexOf(91);
                if (index > 0) {
                    name = name.substring(0, index).trim();
                }
                if ((child = this.compositeQueue.get(name)) == null) continue;
                graph.addEdge((GEdge)new DefaultGEdge((Object)compositeDefinition, (Object)child));
            }
        }
        List verticesInPostOrder = GraphAlgorithms.getVerticesInPostOrder((GDirectedGraph)graph, (GraphNavigator)GraphNavigator.topDownNavigator());
        return verticesInPostOrder;
    }

    void buildDataTypes(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Order PDB datatypes... ");
        List<CompositeDefinition> verticesInPostOrder = this.getCompositeDefinitionsInPostDependencyOrder(monitor);
        monitor.setMessage("Building PDB datatypes... ");
        for (CompositeDefinition compositeDefinition : verticesInPostOrder) {
            monitor.checkCanceled();
            DataType cachedDataType = this.pdbParser.getCachedDataType(compositeDefinition.name);
            SymbolPath symbolPath = new SymbolPath(compositeDefinition.name);
            if (!(cachedDataType instanceof Composite && cachedDataType.getCategoryPath().equals((Object)this.pdbParser.getCategory(symbolPath.getParent(), true)) && this.pdbParser.isCorrectKind(cachedDataType, compositeDefinition.kind))) {
                this.log.appendMsg("PDB", "Conflicting data type name: " + compositeDefinition.name);
                continue;
            }
            Composite composite = (Composite)cachedDataType;
            PdbUtil.clearComponents(composite);
            if (DefaultCompositeMember.applyDataTypeMembers(composite, compositeDefinition.isClass, compositeDefinition.length, this.getNormalMembersOnly(compositeDefinition), msg -> Msg.warn((Object)this, (Object)msg), monitor)) continue;
            PdbUtil.clearComponents(composite);
        }
    }

    private List<PdbParser.PdbXmlMember> getNormalMembersOnly(CompositeDefinition compositeDefinition) {
        if (compositeDefinition.hasNormalMembersOnly) {
            return compositeDefinition.memberList;
        }
        ArrayList<PdbParser.PdbXmlMember> list = new ArrayList<PdbParser.PdbXmlMember>();
        for (PdbParser.PdbXmlMember m : compositeDefinition.memberList) {
            if (m.kind != PdbKind.MEMBER) continue;
            list.add(m);
        }
        return list;
    }

    void preProcessDataTypeList(XmlPullParser xmlParser, boolean isClasses, TaskMonitor monitor) throws CancelledException {
        String elementType;
        monitor.setMessage("Pre-processing PDB datatypes...");
        String string = elementType = isClasses ? "classes" : "datatypes";
        while (xmlParser.hasNext()) {
            monitor.checkCanceled();
            XmlElement elem = xmlParser.peek();
            if (elem.isEnd() && elem.getName().equals(elementType)) {
                xmlParser.next();
                break;
            }
            CompositeDefinition compositeDefinition = new CompositeDefinition(xmlParser);
            if (this.compositeQueue.containsKey(compositeDefinition.name)) continue;
            if (compositeDefinition.isClass) {
                this.pdbParser.predefineClass(compositeDefinition.name);
            }
            this.compositeQueue.put(compositeDefinition.name, compositeDefinition);
            if (this.pdbParser.getCachedDataType(compositeDefinition.name) != null) {
                this.log.appendMsg("PDB", "Data type name collision - unable to define " + compositeDefinition.kind.getCamelName() + ": " + compositeDefinition.name);
                continue;
            }
            Composite composite = this.pdbParser.createComposite(compositeDefinition.kind, compositeDefinition.name);
            if (composite == null) {
                this.log.appendMsg("PDB", "Unsupported datatype kind (" + compositeDefinition.kind + "): " + compositeDefinition.name);
                continue;
            }
            this.pdbParser.cacheDataType(compositeDefinition.name, (DataType)composite);
        }
    }

    private class CompositeDefinition {
        final boolean isClass;
        final PdbKind kind;
        final String name;
        final int length;
        final List<PdbParser.PdbXmlMember> memberList = new ArrayList<PdbParser.PdbXmlMember>();
        final boolean hasNormalMembersOnly;

        CompositeDefinition(XmlPullParser parser) {
            XmlElement startElement = parser.start(new String[0]);
            this.name = SymbolUtilities.replaceInvalidChars((String)startElement.getAttribute("name"), (boolean)false);
            this.length = XmlUtilities.parseInt((String)startElement.getAttribute("length"));
            String kindStr = startElement.getAttribute("kind");
            boolean membersOnly = true;
            XmlElement element = parser.peek();
            while (element != null && element.isStart()) {
                element = parser.start(new String[]{"member"});
                PdbParser.PdbXmlMember pdbXmlMember = ApplyDataTypes.this.pdbParser.getPdbXmlMember(element);
                this.memberList.add(pdbXmlMember);
                membersOnly &= pdbXmlMember.kind == PdbKind.MEMBER;
                parser.end(element);
                element = parser.peek();
            }
            parser.end(startElement);
            this.hasNormalMembersOnly = membersOnly;
            this.isClass = "class".equals(startElement.getName()) || this.isInferredClass(kindStr);
            this.kind = this.isClass ? PdbKind.STRUCTURE : PdbKind.parse(kindStr);
        }

        private boolean isInferredClass(String kindStr) {
            for (PdbParser.PdbXmlMember m : this.memberList) {
                if (m.kind == PdbKind.MEMBER) continue;
                if ("void *".equals(m.memberDataTypeName)) {
                    return true;
                }
                if (!"Function".equals(m.memberDataTypeName)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompositeDefinition other = (CompositeDefinition)obj;
            return this.isClass == other.isClass && this.kind == other.kind && this.length == other.length && SystemUtilities.isEqual((Object)this.name, (Object)other.name);
        }
    }
}

