/*
 * Decompiled with CFR 0.152.
 */
package docking.test;

import docking.FocusOwnerProvider;
import generic.test.TestUtils;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.SwingUtilities;

public class TestKeyEventDispatcher {
    private static TestFocusOwnerProvider focusProvider = new TestFocusOwnerProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dispatchKeyEvent(KeyEvent event) {
        KeyEventDispatcher systemDispatcher = TestKeyEventDispatcher.getOverriddenKeyEventDispatcher();
        if (systemDispatcher == null) {
            return false;
        }
        TestKeyEventDispatcher.focusProvider.focusOwner = event.getComponent();
        try {
            boolean success;
            boolean bl = success = systemDispatcher.dispatchKeyEvent(event);
            return bl;
        }
        finally {
            TestKeyEventDispatcher.focusProvider.focusOwner = null;
        }
    }

    private static KeyEventDispatcher getOverriddenKeyEventDispatcher() {
        try {
            Class<?> clazz = Class.forName("docking.KeyBindingOverrideKeyEventDispatcher");
            Object customDispatcher = TestUtils.getInstanceField((String)"instance", clazz);
            if (customDispatcher == null) {
                return null;
            }
            TestUtils.invokeInstanceMethod((String)"setFocusOwnerProvider", (Object)customDispatcher, FocusOwnerProvider.class, (Object)focusProvider);
            return (KeyEventDispatcher)customDispatcher;
        }
        catch (ClassNotFoundException e) {
            Msg.error(TestKeyEventDispatcher.class, (Object)"Unable to find the system KeyEventDispatcher", (Throwable)e);
            return null;
        }
    }

    private static class TestFocusOwnerProvider
    implements FocusOwnerProvider {
        private Component focusOwner;

        private TestFocusOwnerProvider() {
        }

        @Override
        public Component getFocusOwner() {
            return this.focusOwner;
        }

        @Override
        public Window getActiveWindow() {
            if (this.focusOwner == null) {
                return null;
            }
            if (this.focusOwner instanceof Window) {
                return (Window)this.focusOwner;
            }
            return SwingUtilities.windowForComponent(this.focusOwner);
        }
    }
}

