/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.InlineComponentTitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class InlineComponentTitledPanel
extends JPanel {
    private JPanel content;
    private InlineComponentTitledBorder border;

    public InlineComponentTitledPanel(JComponent titleComponent) {
        this(titleComponent, 1, 2);
    }

    public InlineComponentTitledPanel(JComponent titleComponent, Border otherBorder) {
        this(titleComponent, 1, 2, otherBorder);
    }

    public InlineComponentTitledPanel(JComponent titleComponent, int titleJustification, int titlePosition) {
        this(titleComponent, titleJustification, titlePosition, BorderFactory.createEmptyBorder());
    }

    public InlineComponentTitledPanel(JComponent titleComponent, int titleJustification, int titlePosition, Border otherBorder) {
        Objects.requireNonNull(titleComponent, "InlineComponentTitledPanel requires a component");
        this.border = new InlineComponentTitledBorder(otherBorder, titleComponent, titleJustification, titlePosition);
        super.setBorder(this.border);
        this.setLayout(new BorderLayout());
        this.content = new JPanel();
        this.setTitleComponent(titleComponent);
        super.add((Component)this.content, "Center");
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        Rectangle compR = this.border.getComponentRect(rect, insets);
        this.getTitleComponent().setBounds(compR);
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        this.content.setBounds(rect);
    }

    public JComponent getTitleComponent() {
        return this.border.getTitleComponent();
    }

    public void setTitleComponent(JComponent component) {
        JComponent existing = this.getTitleComponent();
        int existingIndex = -1;
        if (existing != null && (existingIndex = InlineComponentTitledPanel.getComponentIndex(existing)) != -1) {
            super.remove(existingIndex);
        }
        this.border.setTitleComponent(component);
        super.add(component, "Center", existingIndex);
    }

    private static final int getComponentIndex(Component component) {
        if (component != null && component.getParent() != null) {
            Container c = component.getParent();
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (c.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void setBorder(Border otherBorder) {
        this.setOtherBorder(otherBorder);
    }

    public void setOtherBorder(Border otherBorder) {
        if (this.border != null) {
            this.border.setBorder(otherBorder);
        }
        this.invalidate();
    }

    public Border getOtherBorder() {
        return this.border.getBorder();
    }

    public JPanel getContentPane() {
        return this.content;
    }

    @Override
    public Component add(Component comp) {
        return this.content.add(comp);
    }

    @Override
    public Component add(String name, Component comp) {
        return this.content.add(name, comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.content.add(comp, index);
    }

    @Override
    public void remove(int index) {
        this.content.remove(index);
    }

    @Override
    public void remove(Component comp) {
        this.content.remove(comp);
    }

    @Override
    public void removeAll() {
        this.content.removeAll();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.content.setEnabled(enable);
    }
}

