/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.pathmanager;

import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.pathmanager.PathnameTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.framework.preferences.Preferences;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import resources.ResourceManager;
import utility.function.Callback;

public class PathnameTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Icon RESET_ICON = ResourceManager.loadImage((String)"images/trash-empty.png");
    private JTable pathnameTable;
    private PathnameTableModel tableModel;
    private JButton upButton;
    private JButton downButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton resetButton;
    private Color selectionColor;
    private GhidraFileChooser fileChooser;
    private String preferenceForLastSelectedDir = "LastImportDirectory";
    private String title = "Select File";
    private boolean allowMultiFileSelection;
    private GhidraFileFilter filter;
    private boolean addToTop;
    private Callback resetCallback;
    private GhidraFileChooserMode fileChooserMode = GhidraFileChooserMode.FILES_ONLY;

    public PathnameTablePanel(String[] paths, boolean enableEdits, boolean addToTop) {
        super(new BorderLayout(5, 5));
        this.addToTop = addToTop;
        this.tableModel = new PathnameTableModel(paths, enableEdits);
        this.create();
    }

    public PathnameTablePanel(String[] paths, boolean enableEdits, boolean addToTop, Callback resetCallback) {
        super(new BorderLayout(5, 5));
        this.addToTop = addToTop;
        this.resetCallback = resetCallback;
        this.tableModel = new PathnameTableModel(paths, enableEdits);
        this.create();
    }

    public void setFileChooserProperties(String title, String preferenceForLastSelectedDir, GhidraFileChooserMode selectionMode, boolean allowMultiSelection, GhidraFileFilter filter) {
        this.title = Objects.requireNonNull(title);
        this.preferenceForLastSelectedDir = preferenceForLastSelectedDir;
        this.fileChooserMode = Objects.requireNonNull(selectionMode);
        this.allowMultiFileSelection = allowMultiSelection;
        this.filter = filter;
    }

    public void setEditingEnabled(boolean enableEdits) {
        this.tableModel.setEditingEnabled(enableEdits);
    }

    public void setAddToTop(boolean addToTop) {
        this.addToTop = addToTop;
    }

    public String[] getPaths() {
        String[] paths = new String[this.tableModel.getRowCount()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = (String)this.tableModel.getValueAt(i, 0);
        }
        return paths;
    }

    public void setPaths(String[] paths) {
        this.tableModel.setPaths(paths);
    }

    public JTable getTable() {
        return this.pathnameTable;
    }

    public void clear() {
        this.setPaths(new String[0]);
    }

    private void create() {
        this.selectionColor = new Color(204, 204, 255);
        this.upButton = new JButton(ResourceManager.loadImage((String)"images/up.png"));
        this.upButton.setName("UpArrow");
        this.upButton.setToolTipText("Move the selected path up in list");
        this.upButton.addActionListener(e -> this.up());
        this.downButton = new JButton(ResourceManager.loadImage((String)"images/down.png"));
        this.downButton.setName("DownArrow");
        this.downButton.setToolTipText("Move the selected path down in list");
        this.downButton.addActionListener(e -> this.down());
        this.addButton = new JButton(ResourceManager.loadImage((String)"images/Plus.png"));
        this.addButton.setName("AddPath");
        this.addButton.setToolTipText("Display file chooser to select files to add");
        this.addButton.addActionListener(e -> this.add());
        this.removeButton = new JButton(ResourceManager.loadImage((String)"images/edit-delete.png"));
        this.removeButton.setName("RemovePath");
        this.removeButton.setToolTipText("Remove selected path(s) from list");
        this.removeButton.addActionListener(e -> this.remove());
        this.resetButton = new JButton(RESET_ICON);
        this.resetButton.setName("RefreshPaths");
        this.resetButton.setToolTipText("Resets path list to the default values");
        this.resetButton.addActionListener(e -> this.reset());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        buttonPanel.add((Component)this.upButton, gbc);
        gbc.gridy = 1;
        buttonPanel.add((Component)this.downButton, gbc);
        gbc.gridy = 2;
        buttonPanel.add((Component)this.addButton, gbc);
        if (this.resetCallback != null) {
            gbc.gridy = 3;
            buttonPanel.add((Component)this.removeButton, gbc);
            gbc.weighty = 1.0;
            gbc.gridy = 4;
            buttonPanel.add((Component)this.resetButton, gbc);
        } else {
            gbc.weighty = 1.0;
            gbc.gridy = 3;
            buttonPanel.add((Component)this.removeButton, gbc);
        }
        this.pathnameTable = new GTable(this.tableModel);
        this.pathnameTable.setShowGrid(false);
        this.pathnameTable.setPreferredScrollableViewportSize(new Dimension(330, 200));
        this.pathnameTable.setSelectionBackground(this.selectionColor);
        this.pathnameTable.setSelectionForeground(Color.BLACK);
        this.pathnameTable.setTableHeader(null);
        this.pathnameTable.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(this.pathnameTable);
        scrollPane.getViewport().setBackground(this.pathnameTable.getBackground());
        this.setDefaultCellRenderer();
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonPanel, "East");
        ListSelectionModel selModel = this.pathnameTable.getSelectionModel();
        selModel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateButtonsEnabled();
        });
        this.updateButtonsEnabled();
    }

    private void updateButtonsEnabled() {
        int[] rows = this.pathnameTable.getSelectedRows();
        if (this.tableModel.getRowCount() > 1 && rows.length == 1) {
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        this.removeButton.setEnabled(rows.length > 0);
    }

    private void setDefaultCellRenderer() {
        this.pathnameTable.setDefaultRenderer(String.class, new GTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                JTable table = data.getTable();
                Object value = data.getValue();
                boolean isSelected = data.isSelected();
                String pathName = (String)value;
                boolean fileExists = true;
                if (pathName == null) {
                    pathName = "";
                } else {
                    File file = new File(pathName);
                    fileExists = file.exists();
                }
                label.setText(pathName.toString());
                Color fg = isSelected ? table.getSelectionForeground() : table.getForeground();
                label.setForeground(!fileExists ? Color.RED : fg);
                return label;
            }
        });
    }

    private void remove() {
        int[] selectedRows = this.pathnameTable.getSelectedRows();
        if (selectedRows == null) {
            return;
        }
        this.tableModel.remove(selectedRows);
        Arrays.sort(selectedRows);
        int row = selectedRows[selectedRows.length - 1] + 1 - selectedRows.length;
        int count = this.tableModel.getRowCount();
        if (row >= count) {
            row = count - 1;
        }
        if (row >= 0) {
            this.pathnameTable.setRowSelectionInterval(row, row);
        }
        this.updateButtonsEnabled();
    }

    private void add() {
        if (this.fileChooser == null) {
            String dir;
            this.fileChooser = new GhidraFileChooser(this);
            this.fileChooser.setMultiSelectionEnabled(this.allowMultiFileSelection);
            this.fileChooser.setFileSelectionMode(this.fileChooserMode);
            this.fileChooser.setTitle(this.title);
            this.fileChooser.setApproveButtonToolTipText(this.title);
            if (this.filter != null) {
                this.fileChooser.addFileFilter(new GhidraFileFilter(){

                    public String getDescription() {
                        return PathnameTablePanel.this.filter.getDescription();
                    }

                    public boolean accept(File f, GhidraFileChooserModel model) {
                        return PathnameTablePanel.this.filter.accept(f, model);
                    }
                });
            }
            if ((dir = Preferences.getProperty((String)this.preferenceForLastSelectedDir)) != null) {
                this.fileChooser.setCurrentDirectory(new File(dir));
            }
        } else {
            this.fileChooser.rescanCurrentDirectory();
        }
        List<File> files = this.fileChooser.getSelectedFiles();
        String[] paths = new String[]{};
        if (!files.isEmpty()) {
            if (this.allowMultiFileSelection) {
                String parent = files.get(0).getParent();
                Preferences.setProperty((String)this.preferenceForLastSelectedDir, (String)parent);
                paths = new String[files.size()];
                for (int i = 0; i < files.size(); ++i) {
                    paths[i] = files.get(i).getAbsolutePath();
                }
            } else {
                paths = new String[]{files.get(0).getAbsolutePath()};
                Preferences.setProperty((String)this.preferenceForLastSelectedDir, (String)paths[0]);
            }
        }
        this.tableModel.addPaths(paths, this.addToTop);
    }

    private void up() {
        int row = this.pathnameTable.getSelectedRow();
        this.tableModel.moveUp(this.pathnameTable, row);
    }

    private void down() {
        int row = this.pathnameTable.getSelectedRow();
        this.tableModel.moveDown(this.pathnameTable, row);
    }

    private void reset() {
        String confirmation = "Are you sure you would like to reset\nlibrary paths to the default list? This\nwill remove all paths manually added.";
        String header = "Reset Library Paths?";
        int optionChosen = OptionDialog.showYesNoDialog(this, header, confirmation);
        if (this.resetCallback != null && optionChosen == 1) {
            this.resetCallback.call();
        }
    }
}

