/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.common.SolrException;

class BooleanStreamRemoveFunction
extends BooleanValueStream.AbstractBooleanValueStream {
    private final BooleanValueStream baseExpr;
    private final BooleanValue removeExpr;
    public static final String name = "remove";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public BooleanStreamRemoveFunction(BooleanValueStream baseExpr, BooleanValue removeExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.removeExpr = removeExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, removeExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, removeExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        boolean removeValue = this.removeExpr.getBoolean();
        if (this.removeExpr.exists()) {
            this.baseExpr.streamBooleans(value -> {
                if (removeValue != value) {
                    cons.accept(value);
                }
            });
        } else {
            this.baseExpr.streamBooleans(cons);
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

