/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit.sharedterms;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.UniformSplitTerms;
import org.apache.lucene.codecs.uniformsplit.UniformSplitTermsReader;
import org.apache.lucene.codecs.uniformsplit.sharedterms.STUniformSplitTerms;
import org.apache.lucene.codecs.uniformsplit.sharedterms.UnionFieldMetadataBuilder;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.IndexInput;

public class STUniformSplitTermsReader
extends UniformSplitTermsReader {
    public STUniformSplitTermsReader(PostingsReaderBase postingsReader, SegmentReadState state, BlockDecoder blockDecoder, boolean dictionaryOnHeap) throws IOException {
        this(postingsReader, state, blockDecoder, dictionaryOnHeap, FieldMetadata.Serializer.INSTANCE, "SharedTermsUniformSplit", 0, 1, "stustb", "stustd");
    }

    protected STUniformSplitTermsReader(PostingsReaderBase postingsReader, SegmentReadState state, BlockDecoder blockDecoder, boolean dictionaryOnHeap, FieldMetadata.Serializer fieldMetadataReader, String codecName, int versionStart, int versionCurrent, String termsBlocksExtension, String dictionaryExtension) throws IOException {
        super(postingsReader, state, blockDecoder, dictionaryOnHeap, fieldMetadataReader, codecName, versionStart, versionCurrent, termsBlocksExtension, dictionaryExtension);
    }

    @Override
    protected void fillFieldMap(PostingsReaderBase postingsReader, SegmentReadState state, BlockDecoder blockDecoder, boolean dictionaryOnHeap, IndexInput dictionaryInput, IndexInput blockInput, Collection<FieldMetadata> fieldMetadataCollection, FieldInfos fieldInfos) throws IOException {
        if (!fieldMetadataCollection.isEmpty()) {
            FieldMetadata unionFieldMetadata = this.createUnionFieldMetadata(fieldMetadataCollection);
            IndexDictionary.BrowserSupplier dictionaryBrowserSupplier = this.createDictionaryBrowserSupplier(state, dictionaryInput, unionFieldMetadata, blockDecoder, dictionaryOnHeap);
            for (FieldMetadata fieldMetadata : fieldMetadataCollection) {
                this.fieldToTermsMap.put(fieldMetadata.getFieldInfo().name, new STUniformSplitTerms(blockInput, fieldMetadata, unionFieldMetadata, postingsReader, blockDecoder, fieldInfos, dictionaryBrowserSupplier));
            }
        }
    }

    @Override
    protected long getTermsRamBytesUsed() {
        long termsRamUsage = 0L;
        long dictionaryRamUsage = 0L;
        for (UniformSplitTerms terms : this.fieldToTermsMap.values()) {
            termsRamUsage += terms.ramBytesUsedWithoutDictionary();
            dictionaryRamUsage = terms.getDictionaryRamBytesUsed();
        }
        return termsRamUsage += dictionaryRamUsage;
    }

    protected FieldMetadata createUnionFieldMetadata(Iterable<FieldMetadata> fieldMetadataIterable) {
        UnionFieldMetadataBuilder builder = new UnionFieldMetadataBuilder();
        for (FieldMetadata fieldMetadata : fieldMetadataIterable) {
            builder.addFieldMetadata(fieldMetadata);
        }
        return builder.build();
    }
}

