/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class HalfOuterJoinNode
extends JoinNode {
    private boolean rightOuterJoin;
    private boolean transformed = false;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
        super.init(object, object2, object3, object4, null, object6, null);
        this.rightOuterJoin = (Boolean)object5;
        this.flattenableJoin = false;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        if (fromTable.getReferencedTableMap().contains(optimizablePredicate.getReferencedMap())) {
            return fromTable.pushOptPredicate(optimizablePredicate);
        }
        return false;
    }

    public String toString() {
        return "";
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        if (this.rightOuterJoin) {
            ResultSetNode resultSetNode = this.leftResultSet;
            this.leftResultSet = this.rightResultSet;
            this.rightResultSet = resultSetNode;
            this.transformed = true;
        }
        ResultSetNode resultSetNode = super.preprocess(n, groupByList, fromList);
        return resultSetNode;
    }

    public void pushExpressions(PredicateList predicateList) throws StandardException {
        FromTable fromTable = (FromTable)this.leftResultSet;
        FromTable fromTable2 = (FromTable)this.rightResultSet;
        this.pushExpressionsToLeft(predicateList);
        for (int i = this.joinPredicates.size() - 1; i >= 0; --i) {
            Predicate predicate = (Predicate)this.joinPredicates.elementAt(i);
            if (!predicate.getPushable()) continue;
            this.getRightPredicateList().addPredicate(predicate);
            this.joinPredicates.removeElementAt(i);
        }
        PredicateList predicateList2 = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        fromTable.pushExpressions(this.getLeftPredicateList());
        fromTable2.pushExpressions(predicateList2);
    }

    public boolean LOJ_reorderable(int n) throws StandardException {
        ResultSetNode resultSetNode;
        ResultSetNode resultSetNode2;
        boolean bl = false;
        if (this.rightOuterJoin) {
            resultSetNode2 = this.rightResultSet;
            resultSetNode = this.leftResultSet;
        } else {
            resultSetNode2 = this.leftResultSet;
            resultSetNode = this.rightResultSet;
        }
        super.normExpressions();
        if (resultSetNode2 instanceof FromBaseTable && resultSetNode instanceof FromBaseTable) {
            return bl;
        }
        if (resultSetNode2 instanceof HalfOuterJoinNode) {
            bl = ((HalfOuterJoinNode)resultSetNode2).LOJ_reorderable(n) || bl;
        } else if (!(resultSetNode2 instanceof FromBaseTable)) {
            return bl;
        }
        if (resultSetNode instanceof HalfOuterJoinNode) {
            bl = ((HalfOuterJoinNode)resultSetNode).LOJ_reorderable(n) || bl;
        } else if (!(resultSetNode instanceof FromBaseTable)) {
            return bl;
        }
        if (this.rightOuterJoin || resultSetNode instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)resultSetNode).rightOuterJoin) {
            return this.LOJ_bindResultColumns(bl);
        }
        JBitSet jBitSet = resultSetNode2.LOJgetReferencedTables(n);
        JBitSet jBitSet2 = resultSetNode.LOJgetReferencedTables(n);
        if ((jBitSet == null || jBitSet2 == null) && bl) {
            return this.LOJ_bindResultColumns(bl);
        }
        if (resultSetNode instanceof HalfOuterJoinNode) {
            JBitSet jBitSet3 = ((HalfOuterJoinNode)resultSetNode).LOJgetRPReferencedTables(n);
            if (!this.isNullRejecting(this.joinClause, jBitSet, jBitSet3)) {
                return this.LOJ_bindResultColumns(bl);
            }
            JBitSet jBitSet4 = ((HalfOuterJoinNode)resultSetNode).LOJgetNPReferencedTables(n);
            if (this.isNullRejecting(((HalfOuterJoinNode)resultSetNode).joinClause, jBitSet3, jBitSet4)) {
                if (this.subqueryList.size() != 0 || ((JoinNode)resultSetNode).subqueryList.size() != 0 || this.joinPredicates.size() != 0 || ((JoinNode)resultSetNode).joinPredicates.size() != 0 || this.usingClause != null || ((JoinNode)resultSetNode).usingClause != null) {
                    return this.LOJ_bindResultColumns(bl);
                }
                bl = true;
                ResultSetNode resultSetNode3 = resultSetNode2;
                ResultSetNode resultSetNode4 = ((HalfOuterJoinNode)resultSetNode).leftResultSet;
                ResultSetNode resultSetNode5 = ((HalfOuterJoinNode)resultSetNode).rightResultSet;
                ((HalfOuterJoinNode)resultSetNode).rightResultSet = resultSetNode4;
                ((HalfOuterJoinNode)resultSetNode).leftResultSet = resultSetNode3;
                QueryTreeNode queryTreeNode = this.joinClause;
                this.joinClause = ((HalfOuterJoinNode)resultSetNode).joinClause;
                ((HalfOuterJoinNode)resultSetNode).joinClause = queryTreeNode;
                queryTreeNode = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
                this.leftResultSet = resultSetNode;
                this.rightResultSet = resultSetNode5;
                ((HalfOuterJoinNode)this.leftResultSet).resultColumns = null;
                ((JoinNode)this.leftResultSet).bindResultColumns((FromList)queryTreeNode);
                boolean bl2 = ((HalfOuterJoinNode)this.leftResultSet).LOJ_reorderable(n);
            }
        }
        return this.LOJ_bindResultColumns(bl);
    }

    private boolean isNullRejecting(ValueNode valueNode, JBitSet jBitSet, JBitSet jBitSet2) throws StandardException {
        ValueNode valueNode2 = valueNode;
        boolean bl = false;
        while (valueNode2 != null) {
            AndNode andNode = null;
            if (valueNode2 instanceof AndNode) {
                andNode = (AndNode)valueNode2;
                valueNode2 = andNode.getLeftOperand();
            }
            if (valueNode2 instanceof BinaryRelationalOperatorNode) {
                BinaryRelationalOperatorNode binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)valueNode2;
                ValueNode valueNode3 = binaryRelationalOperatorNode.getLeftOperand();
                ValueNode valueNode4 = binaryRelationalOperatorNode.getRightOperand();
                boolean bl2 = false;
                boolean bl3 = false;
                if (valueNode3 instanceof ColumnReference) {
                    if (jBitSet.get(((ColumnReference)valueNode3).getTableNumber())) {
                        bl2 = true;
                    } else if (jBitSet2.get(((ColumnReference)valueNode3).getTableNumber())) {
                        bl3 = true;
                    } else {
                        return false;
                    }
                }
                if (valueNode4 instanceof ColumnReference) {
                    if (jBitSet.get(((ColumnReference)valueNode4).getTableNumber())) {
                        bl2 = true;
                    } else if (jBitSet2.get(((ColumnReference)valueNode4).getTableNumber())) {
                        bl3 = true;
                    } else {
                        return false;
                    }
                }
                if (bl2 && bl3) {
                    bl = true;
                }
            } else if (!(valueNode2 instanceof BooleanConstantNode) || !bl) {
                return false;
            }
            if (andNode != null) {
                valueNode2 = andNode.getRightOperand();
                continue;
            }
            valueNode2 = null;
        }
        return bl;
    }

    public boolean LOJ_bindResultColumns(boolean bl) throws StandardException {
        if (bl) {
            this.resultColumns = null;
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindResultColumns(fromList);
        }
        return bl;
    }

    public FromTable transformOuterJoins(ValueNode valueNode, int n) throws StandardException {
        if (valueNode == null) {
            this.leftResultSet.notFlattenableJoin();
            this.rightResultSet.notFlattenableJoin();
            return this;
        }
        super.transformOuterJoins(valueNode, n);
        ResultSetNode resultSetNode = this.rightOuterJoin ? this.leftResultSet : this.rightResultSet;
        JBitSet jBitSet = resultSetNode.LOJgetReferencedTables(n);
        ValueNode valueNode2 = valueNode;
        while (valueNode2 instanceof AndNode) {
            AndNode andNode = (AndNode)valueNode2;
            ValueNode valueNode3 = andNode.getLeftOperand();
            if (valueNode3.isInstanceOf(25)) {
                valueNode2 = andNode.getRightOperand();
                continue;
            }
            if (valueNode3 instanceof RelationalOperator) {
                JBitSet jBitSet2 = new JBitSet(n);
                if (!valueNode3.categorize(jBitSet2, true)) {
                    valueNode2 = andNode.getRightOperand();
                    continue;
                }
                for (int i = 0; i < n; ++i) {
                    if (!jBitSet2.get(i) || !jBitSet.get(i)) continue;
                    JoinNode joinNode = (JoinNode)this.getNodeFactory().getNode(139, this.leftResultSet, this.rightResultSet, this.joinClause, null, this.resultColumns, null, null, this.getContextManager());
                    joinNode.setTableNumber(this.tableNumber);
                    joinNode.setSubqueryList(this.subqueryList);
                    joinNode.setAggregateVector(this.aggregateVector);
                    return joinNode;
                }
            }
            valueNode2 = andNode.getRightOperand();
        }
        this.leftResultSet.notFlattenableJoin();
        this.rightResultSet.notFlattenableJoin();
        return this;
    }

    protected void adjustNumberOfRowsReturned(CostEstimate costEstimate) {
        CostEstimate costEstimate2 = this.getLeftResultSet().getCostEstimate();
        if (costEstimate.rowCount() < costEstimate2.rowCount()) {
            costEstimate.setCost(costEstimate.getEstimatedCost(), costEstimate2.rowCount(), costEstimate2.rowCount());
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        super.generateCore(activationClassBuilder, methodBuilder, 3);
    }

    protected int addOuterJoinArguments(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.rightResultSet.getResultColumns().generateNulls(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.rightOuterJoin);
        return 2;
    }

    protected int getNumJoinArguments() {
        return super.getNumJoinArguments() + 2;
    }

    protected void oneRowRightSide(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) {
        methodBuilder.push(false);
        methodBuilder.push(false);
    }

    ResultSetNode getLogicalLeftResultSet() {
        if (this.rightOuterJoin) {
            return this.rightResultSet;
        }
        return this.leftResultSet;
    }

    ResultSetNode getLogicalRightResultSet() {
        if (this.rightOuterJoin) {
            return this.leftResultSet;
        }
        return this.rightResultSet;
    }

    public boolean isRightOuterJoin() {
        return this.rightOuterJoin;
    }

    public void isJoinColumnForRightOuterJoin(ResultColumn resultColumn) {
        if (this.isRightOuterJoin() && this.usingClause != null && this.usingClause.getResultColumn(resultColumn.getUnderlyingOrAliasName()) != null) {
            resultColumn.setRightOuterJoinUsingClause(true);
            resultColumn.setJoinResultset(this);
        }
    }

    public JBitSet LOJgetNPReferencedTables(int n) throws StandardException {
        if (this.rightOuterJoin && !this.transformed) {
            return this.leftResultSet.LOJgetReferencedTables(n);
        }
        return this.rightResultSet.LOJgetReferencedTables(n);
    }

    public JBitSet LOJgetRPReferencedTables(int n) throws StandardException {
        if (this.rightOuterJoin && !this.transformed) {
            return this.rightResultSet.LOJgetReferencedTables(n);
        }
        return this.leftResultSet.LOJgetReferencedTables(n);
    }
}

