/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters.jmx;

import com.codahale.metrics.jmx.ObjectNameFactory;
import java.util.Arrays;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.solr.metrics.SolrMetricInfo;

public class JmxObjectNameFactory
implements ObjectNameFactory {
    private final String domain;
    private final String[] subdomains;
    private final String reporterName;
    private final String[] props;

    public JmxObjectNameFactory(String reporterName, String domain, String ... additionalProperties) {
        this.reporterName = reporterName.replaceAll(":", "_");
        this.domain = domain;
        this.subdomains = domain.replaceAll(":", "_").split("\\.");
        if (additionalProperties != null && additionalProperties.length % 2 != 0) {
            throw new IllegalArgumentException("additionalProperties length must be even: " + Arrays.toString(additionalProperties));
        }
        this.props = additionalProperties;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getReporterName() {
        return this.reporterName;
    }

    public ObjectName createName(String type, String currentDomain, String name) {
        ObjectName objectName;
        int i;
        SolrMetricInfo metricInfo = SolrMetricInfo.of(name);
        String safeName = metricInfo != null ? metricInfo.name : name;
        safeName = safeName.replaceAll(":", "_");
        StringBuilder sb = new StringBuilder();
        if (this.domain.equals(currentDomain)) {
            if (this.subdomains != null && this.subdomains.length > 1) {
                sb.append(this.subdomains[0]);
                sb.append(':');
                for (int i2 = 1; i2 < this.subdomains.length; ++i2) {
                    if (i2 > 1) {
                        sb.append(',');
                    }
                    sb.append("dom");
                    sb.append(String.valueOf(i2));
                    sb.append('=');
                    sb.append(this.subdomains[i2]);
                }
                sb.append(',');
            } else {
                sb.append(currentDomain.replaceAll(":", "_"));
                sb.append(':');
            }
        } else {
            sb.append(currentDomain);
            sb.append(':');
        }
        if (this.props != null && this.props.length > 0) {
            boolean added = false;
            for (i = 0; i < this.props.length; i += 2) {
                if (this.props[i] == null || this.props[i].isEmpty() || this.props[i + 1] == null || this.props[i + 1].isEmpty()) continue;
                sb.append(',');
                sb.append(this.props[i]);
                sb.append('=');
                sb.append(this.props[i + 1]);
                added = true;
            }
            if (added) {
                sb.append(',');
            }
        }
        if (metricInfo != null) {
            sb.append("category=");
            sb.append(metricInfo.category.toString());
            if (metricInfo.scope != null) {
                sb.append(",scope=");
                sb.append(metricInfo.scope);
            }
            sb.append(",name=");
            sb.append(safeName);
        } else {
            String[] path = safeName.split("\\.");
            for (i = 0; i < path.length - 1; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append("name");
                sb.append(String.valueOf(i));
                sb.append('=');
                sb.append(path[i]);
            }
            if (path.length > 1) {
                sb.append(',');
            }
            sb.append("name=");
            sb.append(path[path.length - 1]);
        }
        try {
            objectName = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(sb.toString(), e);
        }
        return objectName;
    }
}

