/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.util;

public class HexUtil {
    static final String HEX_CHARS_STR = "0123456789ABCDEF";
    static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public static String bytesToHexFriendly(byte[] bytes) {
        int len = bytes.length * 2;
        len += bytes.length;
        char[] hexChars = new char[len += 2];
        hexChars[0] = 48;
        hexChars[1] = 120;
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 3 + 2] = HEX_CHARS[v >>> 4];
            hexChars[j * 3 + 3] = HEX_CHARS[v & 0xF];
            hexChars[j * 3 + 4] = 32;
        }
        return new String(hexChars);
    }

    public static byte[] hex2bytesFriendly(String hexString) {
        String hexStr = hexString = hexString.toUpperCase();
        if (hexString.startsWith("0X")) {
            hexStr = hexString.substring(2);
        }
        String[] hexParts = hexStr.split(" ");
        byte[] bytes = new byte[hexParts.length];
        for (int i = 0; i < hexParts.length; ++i) {
            char[] hexPart = hexParts[i].toCharArray();
            if (hexPart.length != 2) {
                throw new IllegalArgumentException("Invalid hex string to convert");
            }
            bytes[i] = (byte)((HEX_CHARS_STR.indexOf(hexPart[0]) << 4) + HEX_CHARS_STR.indexOf(hexPart[1]));
        }
        return bytes;
    }

    public static String bytesToHex(byte[] bytes) {
        int len = bytes.length * 2;
        char[] hexChars = new char[len];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHARS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hex2bytes(String hexString) {
        hexString = hexString.toUpperCase();
        int len = hexString.length() / 2;
        byte[] bytes = new byte[len];
        char[] hexChars = hexString.toCharArray();
        int j = 0;
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)((HEX_CHARS_STR.indexOf(hexChars[j++]) << 4) + HEX_CHARS_STR.indexOf(hexChars[j++]));
        }
        return bytes;
    }
}

