/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.List;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.MaterializationService;
import org.apache.calcite.materialize.TileKey;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelOptLattice {
    public final Lattice lattice;
    public final RelOptTable starRelOptTable;

    public RelOptLattice(Lattice lattice, RelOptTable starRelOptTable) {
        this.lattice = lattice;
        this.starRelOptTable = starRelOptTable;
    }

    public RelOptTable rootTable() {
        return this.lattice.rootNode.relOptTable();
    }

    public @Nullable RelNode rewrite(RelNode node) {
        return RelOptMaterialization.tryUseStar(node, this.starRelOptTable);
    }

    public @Nullable Pair<CalciteSchema.TableEntry, TileKey> getAggregate(RelOptPlanner planner, ImmutableBitSet groupSet, List<Lattice.Measure> measureList) {
        CalciteConnectionConfig config = planner.getContext().unwrap(CalciteConnectionConfig.class);
        if (config == null) {
            return null;
        }
        MaterializationService service = MaterializationService.instance();
        boolean create = this.lattice.auto && config.createMaterializations();
        CalciteSchema schema = this.starRelOptTable.unwrap(CalciteSchema.class);
        assert (schema != null) : "Can't get CalciteSchema from " + this.starRelOptTable;
        return service.defineTile(this.lattice, groupSet, measureList, schema, create, false);
    }
}

