/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Objects;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.solr.search.FilteredDocIdSet;

public final class BitsFilteredDocIdSet
extends FilteredDocIdSet {
    private final Bits acceptDocs;

    public static DocIdSet wrap(DocIdSet set, Bits acceptDocs) {
        return set == null || acceptDocs == null ? set : new BitsFilteredDocIdSet(set, acceptDocs);
    }

    public BitsFilteredDocIdSet(DocIdSet innerSet, Bits acceptDocs) {
        super(innerSet);
        this.acceptDocs = Objects.requireNonNull(acceptDocs, "Bits must not be null");
    }

    @Override
    protected boolean match(int docid) {
        return this.acceptDocs.get(docid);
    }
}

