/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.function.IntFunction;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.UnInvertedField;

public abstract class UnInvertedFieldAcc
extends SlotAcc
implements UnInvertedField.Callback {
    UnInvertedField uif;
    UnInvertedField.DocToTerm docToTerm;
    SchemaField sf;

    public UnInvertedFieldAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
        super(fcontext);
        this.sf = sf;
        this.uif = UnInvertedField.getUnInvertedField(sf.getName(), fcontext.qcontext.searcher());
        this.docToTerm = this.uif.new UnInvertedField.DocToTerm();
        fcontext.qcontext.addCloseHook(this);
    }

    @Override
    public void close() throws IOException {
        if (this.docToTerm != null) {
            this.docToTerm.close();
            this.docToTerm = null;
        }
    }

    static abstract class SDVUnInvertedFieldAcc
    extends DoubleUnInvertedFieldAcc {
        int[] counts;
        double[] sum;

        public SDVUnInvertedFieldAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
            this.counts = new int[numSlots];
            this.sum = new double[numSlots];
        }

        @Override
        public void call(int termNum) {
            try {
                BytesRef term = this.docToTerm.lookupOrd(termNum);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                int n = this.currentSlot;
                this.result[n] = this.result[n] + val * val;
                int n2 = this.currentSlot;
                this.sum[n2] = this.sum[n2] + val;
                int n3 = this.currentSlot;
                this.counts[n3] = this.counts[n3] + 1;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected abstract double computeVal(int var1);

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.computeVal(slotA), this.computeVal(slotB));
        }

        @Override
        public Object getValue(int slot) {
            if (this.fcontext.isShard()) {
                ArrayList<Number> lst = new ArrayList<Number>(3);
                lst.add(this.counts[slot]);
                lst.add(this.result[slot]);
                lst.add(this.sum[slot]);
                return lst;
            }
            return this.computeVal(slot);
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            Arrays.fill(this.counts, 0);
            Arrays.fill(this.sum, 0.0);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            super.resize(resizer);
            this.counts = resizer.resize(this.counts, 0);
            this.sum = resizer.resize(this.sum, 0.0);
        }
    }

    static abstract class DoubleUnInvertedFieldAcc
    extends UnInvertedFieldAcc {
        double[] result;
        int currentSlot;
        double initialValue;

        public DoubleUnInvertedFieldAcc(FacetContext fcontext, SchemaField sf, int numSlots, double initialValue) throws IOException {
            super(fcontext, sf, numSlots);
            this.result = new double[numSlots];
            if (initialValue != 0.0) {
                this.initialValue = initialValue;
                Arrays.fill(this.result, initialValue);
            }
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            this.currentSlot = slot;
            this.docToTerm.getBigTerms(doc + this.currentDocBase, this);
            this.docToTerm.getSmallTerms(doc + this.currentDocBase, this);
        }

        @Override
        public int compare(int slotA, int slotB) {
            return Double.compare(this.result[slotA], this.result[slotB]);
        }

        @Override
        public Object getValue(int slotNum) throws IOException {
            return this.result[slotNum];
        }

        @Override
        public void reset() throws IOException {
            Arrays.fill(this.result, this.initialValue);
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.result = resizer.resize(this.result, this.initialValue);
        }
    }
}

