/*
 * Decompiled with CFR 0.152.
 */
package generic.jar;

import generic.jar.FileResource;
import generic.jar.JarEntryFilter;
import generic.jar.JarResource;
import generic.jar.Resource;
import generic.jar.ResourceFileFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ResourceFile
implements Comparable<ResourceFile> {
    private static final String JAR_FILE_PREFIX = "jar:file:";
    private Resource resource;
    private static Map<String, JarResource> jarRootsMap = new HashMap<String, JarResource>();

    public ResourceFile(File file) {
        this.resource = new FileResource(file);
    }

    public ResourceFile(ResourceFile resourceFile, String path) {
        if (resourceFile == null) {
            throw new IllegalArgumentException("Parent ResourceFile cannot be null.");
        }
        this.resource = resourceFile.resource.getResource(path);
    }

    ResourceFile(Resource resource) {
        this.resource = resource;
    }

    public ResourceFile(String absolutePath) {
        this(absolutePath, null);
    }

    public ResourceFile(String absolutePath, JarEntryFilter filter) {
        if (absolutePath.startsWith(JAR_FILE_PREFIX)) {
            int indexOf = absolutePath.indexOf("!/");
            if (indexOf < 0) {
                throw new IllegalArgumentException("Invalid jar specification: " + absolutePath);
            }
            String filePath = absolutePath.substring(JAR_FILE_PREFIX.length(), indexOf);
            String relativePath = absolutePath.substring(indexOf + 2);
            Resource root = jarRootsMap.get(filePath);
            try {
                if (root == null) {
                    root = ResourceFile.openJarResourceFile((File)new File((String)filePath), (JarEntryFilter)filter).resource;
                }
                this.resource = root.getResource(relativePath);
                return;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to open jar: " + filePath, e);
            }
        }
        this.resource = new FileResource(new File(absolutePath));
    }

    public static ResourceFile openJarResourceFile(File jarFile, JarEntryFilter filter) throws IOException {
        JarResource root = new JarResource(jarFile, filter);
        ResourceFile rootResourceFile = new ResourceFile(root);
        jarRootsMap.put(jarFile.getCanonicalPath(), root);
        return rootResourceFile;
    }

    public String getAbsolutePath() {
        return this.resource.getAbsolutePath();
    }

    public String getCanonicalPath() throws IOException {
        return this.resource.getCanonicalPath();
    }

    public ResourceFile[] listFiles() {
        return this.resource.listFiles();
    }

    public ResourceFile[] listFiles(ResourceFileFilter filter) {
        return this.resource.listFiles(filter);
    }

    public String getName() {
        return this.resource.getName();
    }

    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    public ResourceFile getParentFile() {
        Resource parent = this.resource.getParent();
        return parent == null ? null : new ResourceFile(parent);
    }

    public URL toURL() throws MalformedURLException {
        return this.resource.toURL();
    }

    public long lastModified() {
        return this.resource.lastModified();
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        return this.resource.getInputStream();
    }

    public boolean delete() {
        return this.resource.delete();
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        return this.resource.getOutputStream();
    }

    public File getFile(boolean copyIfNeeded) {
        if (copyIfNeeded) {
            return this.resource.getResourceAsFile(this);
        }
        return this.resource.getFile();
    }

    public long length() {
        return this.resource.length();
    }

    public boolean isFile() {
        return this.resource.isFile();
    }

    public ResourceFile getCanonicalFile() {
        Resource newResource = this.resource.getCanonicalResource();
        if (this.resource == newResource) {
            return this;
        }
        return new ResourceFile(newResource);
    }

    public boolean canWrite() {
        return this.resource.canWrite();
    }

    public boolean mkdir() {
        return this.resource.mkdir();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.resource.equals(((ResourceFile)obj).resource);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    @Override
    public int compareTo(ResourceFile o) {
        return this.getAbsolutePath().compareTo(o.getAbsolutePath());
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public File getFileSystemRoot() {
        return this.resource.getFileSystemRoot();
    }

    public URI toURI() {
        return this.resource.toURI();
    }
}

