/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import org.catacombae.hfsexplorer.Util;
import org.catacombae.io.ReadableRandomAccessStream;

public class FileSystemRecognizer {
    private static final short SIGNATURE_MFS = -11561;
    private static final short SIGNATURE_HFS = 16964;
    private static final short SIGNATURE_HFS_PLUS = 18475;
    private static final short SIGNATURE_HFSX = 18520;
    public static final FileSystemType[] supportedTypes = new FileSystemType[]{FileSystemType.HFS, FileSystemType.HFS_PLUS, FileSystemType.HFS_WRAPPED_HFS_PLUS, FileSystemType.HFSX};
    private ReadableRandomAccessStream bitstream;
    private long offset;

    public FileSystemRecognizer(ReadableRandomAccessStream bitstream, long offset) {
        this.bitstream = bitstream;
        this.offset = offset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileSystemType detectFileSystem() {
        try {
            this.bitstream.seek(this.offset + 1024L);
            byte[] signatureData = new byte[2];
            this.bitstream.readFully(signatureData);
            short signature = Util.readShortBE((byte[])signatureData);
            switch (signature) {
                case -11561: {
                    return FileSystemType.MFS;
                }
                case 16964: {
                    try {
                        this.bitstream.seek(this.offset + 1024L + 124L);
                        this.bitstream.readFully(signatureData);
                        short embeddedSignature = Util.readShortBE((byte[])signatureData);
                        if (embeddedSignature == 18475) {
                            return FileSystemType.HFS_WRAPPED_HFS_PLUS;
                        }
                        return FileSystemType.HFS;
                    }
                    catch (Exception e) {
                        return FileSystemType.HFS;
                    }
                }
                case 18475: {
                    return FileSystemType.HFS_PLUS;
                }
                case 18520: {
                    return FileSystemType.HFSX;
                }
            }
            return FileSystemType.UNKNOWN;
        }
        catch (Exception e) {
            return FileSystemType.UNKNOWN;
        }
    }

    public boolean isTypeSupported(FileSystemType fst) {
        for (FileSystemType cur : supportedTypes) {
            if (cur != fst) continue;
            return true;
        }
        return false;
    }

    public FileSystemType[] getSupportedTypes() {
        FileSystemType[] res = new FileSystemType[supportedTypes.length];
        System.arraycopy(supportedTypes, 0, res, 0, supportedTypes.length);
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileSystemType {
        MFS,
        HFS,
        HFS_PLUS,
        HFS_WRAPPED_HFS_PLUS,
        HFSX,
        UNKNOWN;

    }
}

