/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfs;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.finder.DInfo;
import org.catacombae.hfsexplorer.types.finder.DXInfo;
import org.catacombae.hfsexplorer.types.hfs.CatDataRec;
import org.catacombae.hfsexplorer.types.hfs.HFSDateField;

public class CdrDirRec
extends CatDataRec {
    public static final int STRUCTSIZE = 70;
    private final byte[] dirFlags = new byte[2];
    private final byte[] dirVal = new byte[2];
    private final byte[] dirDirID = new byte[4];
    private final byte[] dirCrDat = new byte[4];
    private final byte[] dirMdDat = new byte[4];
    private final byte[] dirBkDat = new byte[4];
    private final DInfo dirUsrInfo;
    private final DXInfo dirFndrInfo;
    private final byte[] dirResrv = new byte[16];

    public CdrDirRec(byte[] data, int offset) {
        super(data, offset);
        System.arraycopy(data, offset + 2, this.dirFlags, 0, 2);
        System.arraycopy(data, offset + 4, this.dirVal, 0, 2);
        System.arraycopy(data, offset + 6, this.dirDirID, 0, 4);
        System.arraycopy(data, offset + 10, this.dirCrDat, 0, 4);
        System.arraycopy(data, offset + 14, this.dirMdDat, 0, 4);
        System.arraycopy(data, offset + 18, this.dirBkDat, 0, 4);
        this.dirUsrInfo = new DInfo(data, offset + 22);
        this.dirFndrInfo = new DXInfo(data, offset + 38);
        System.arraycopy(data, offset + 54, this.dirResrv, 0, 16);
    }

    public static int length() {
        return 70;
    }

    public short getDirFlags() {
        return Util.readShortBE((byte[])this.dirFlags);
    }

    public short getDirVal() {
        return Util.readShortBE((byte[])this.dirVal);
    }

    public int getDirDirID() {
        return Util.readIntBE((byte[])this.dirDirID);
    }

    public int getDirCrDat() {
        return Util.readIntBE((byte[])this.dirCrDat);
    }

    public int getDirMdDat() {
        return Util.readIntBE((byte[])this.dirMdDat);
    }

    public int getDirBkDat() {
        return Util.readIntBE((byte[])this.dirBkDat);
    }

    public DInfo getDirUsrInfo() {
        return this.dirUsrInfo;
    }

    public DXInfo getDirFndrInfo() {
        return this.dirFndrInfo;
    }

    public int[] getDirResrv() {
        return Util.readIntArrayBE((byte[])this.dirResrv);
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(CdrDirRec.class.getSimpleName());
        super.addSuperStructElements(db);
        db.addUIntBE("dirFlags", this.dirFlags, "Directory flags", BINARY);
        db.addUIntBE("dirVal", this.dirVal, "Valence");
        db.addUIntBE("dirDirID", this.dirDirID, "Directory ID");
        db.add("dirCrDat", new HFSDateField(this.dirCrDat), "Creation date");
        db.add("dirMdDat", new HFSDateField(this.dirMdDat), "Modification date");
        db.add("dirBkDat", new HFSDateField(this.dirBkDat), "Backup date");
        db.add("dirUsrInfo", this.dirUsrInfo.getStructElements(), "Finder info");
        db.add("dirFndrInfo", this.dirFndrInfo.getStructElements(), "Extended Finder info");
        db.addIntArray("dirResrv", this.dirResrv, BITS_32, UNSIGNED, BIG_ENDIAN, "Reserved", HEXADECIMAL);
        return db.getResult();
    }

    public void printFields(PrintStream ps, String prefix) {
        super.printFields(ps, prefix);
        ps.println(prefix + " cdrType: " + this.getCdrType());
        ps.println(prefix + " cdrResrv2: " + this.getCdrResrv2());
        ps.println(prefix + " dirFlags: " + this.getDirFlags());
        ps.println(prefix + " dirVal: " + this.getDirVal());
        ps.println(prefix + " dirDirID: " + this.getDirDirID());
        ps.println(prefix + " dirCrDat: " + this.getDirCrDat());
        ps.println(prefix + " dirMdDat: " + this.getDirMdDat());
        ps.println(prefix + " dirBkDat: " + this.getDirBkDat());
        ps.println(prefix + " dirUsrInfo: ");
        this.getDirUsrInfo().print(ps, prefix + "  ");
        ps.println(prefix + " dirFndrInfo: ");
        this.getDirFndrInfo().print(ps, prefix + "  ");
        ps.println(prefix + " dirResrv: " + this.getDirResrv());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "CdrDirRec:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.size()];
        int offset = 0;
        byte[] superData = super.getBytes();
        System.arraycopy(superData, 0, result, offset, superData.length);
        System.arraycopy(this.dirFlags, 0, result, offset += superData.length, this.dirFlags.length);
        System.arraycopy(this.dirVal, 0, result, offset += this.dirFlags.length, this.dirVal.length);
        System.arraycopy(this.dirDirID, 0, result, offset += this.dirVal.length, this.dirDirID.length);
        System.arraycopy(this.dirCrDat, 0, result, offset += this.dirDirID.length, this.dirCrDat.length);
        System.arraycopy(this.dirMdDat, 0, result, offset += this.dirCrDat.length, this.dirMdDat.length);
        System.arraycopy(this.dirBkDat, 0, result, offset += this.dirMdDat.length, this.dirBkDat.length);
        byte[] tempData = this.dirUsrInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.dirBkDat.length, tempData.length);
        offset += tempData.length;
        tempData = this.dirFndrInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        System.arraycopy(this.dirResrv, 0, result, offset += tempData.length, this.dirResrv.length);
        offset += this.dirResrv.length;
        return result;
    }

    public int size() {
        return CdrDirRec.length();
    }
}

