/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.fs;

import java.util.Date;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.jparted.lib.fs.WindowsFileAttributes;

public abstract class FSAttributes {
    public abstract boolean hasPOSIXFileAttributes();

    public abstract POSIXFileAttributes getPOSIXFileAttributes();

    public abstract boolean hasWindowsFileAttributes();

    public abstract WindowsFileAttributes getWindowsFileAttributes();

    public abstract boolean hasCreateDate();

    public abstract Date getCreateDate();

    public abstract boolean hasModifyDate();

    public abstract Date getModifyDate();

    public abstract boolean hasAttributeModifyDate();

    public abstract Date getAttributeModifyDate();

    public abstract boolean hasAccessDate();

    public abstract Date getAccessDate();

    public abstract boolean hasBackupDate();

    public abstract Date getBackupDate();

    public static class DefaultPOSIXFileAttributes
    extends POSIXFileAttributes {
        private final short fileMode;
        private final long userID;
        private final long groupID;

        public DefaultPOSIXFileAttributes(long userID, long groupID, short fileMode) {
            this.userID = userID;
            this.groupID = groupID;
            this.fileMode = fileMode;
        }

        public long getUserID() {
            return this.userID;
        }

        public long getGroupID() {
            return this.groupID;
        }

        public byte getFileType() {
            int type = this.fileMode >> 12 & 0xF;
            return (byte)type;
        }

        public boolean isSetUID() {
            return Util.getBit((long)this.fileMode, (int)11);
        }

        public boolean isSetGID() {
            return Util.getBit((long)this.fileMode, (int)10);
        }

        public boolean isStickyBit() {
            return Util.getBit((long)this.fileMode, (int)9);
        }

        public boolean canUserRead() {
            return Util.getBit((long)this.fileMode, (int)8);
        }

        public boolean canUserWrite() {
            return Util.getBit((long)this.fileMode, (int)7);
        }

        public boolean canUserExecute() {
            return Util.getBit((long)this.fileMode, (int)6);
        }

        public boolean canGroupRead() {
            return Util.getBit((long)this.fileMode, (int)5);
        }

        public boolean canGroupWrite() {
            return Util.getBit((long)this.fileMode, (int)4);
        }

        public boolean canGroupExecute() {
            return Util.getBit((long)this.fileMode, (int)3);
        }

        public boolean canOthersRead() {
            return Util.getBit((long)this.fileMode, (int)2);
        }

        public boolean canOthersWrite() {
            return Util.getBit((long)this.fileMode, (int)1);
        }

        public boolean canOthersExecute() {
            return Util.getBit((long)this.fileMode, (int)0);
        }

        public String getPermissionString() {
            String result;
            byte fileType = this.getFileType();
            switch (fileType) {
                case 0: {
                    result = "?";
                    break;
                }
                case 1: {
                    result = "p";
                    break;
                }
                case 2: {
                    result = "c";
                    break;
                }
                case 4: {
                    result = "d";
                    break;
                }
                case 6: {
                    result = "b";
                    break;
                }
                case 8: {
                    result = "-";
                    break;
                }
                case 10: {
                    result = "l";
                    break;
                }
                case 12: {
                    result = "s";
                    break;
                }
                case 14: {
                    result = "w";
                    break;
                }
                default: {
                    result = " ";
                    System.err.println("[FSAttributes.POSIXFileAttributes.getFileModeString()] Unknown file type:  " + fileType + " Mode: 0x" + Util.toHexStringBE((short)this.fileMode));
                }
            }
            result = this.canUserRead() ? result + "r" : result + "-";
            result = this.canUserWrite() ? result + "w" : result + "-";
            result = this.canUserExecute() ? (this.isSetUID() ? result + "s" : result + "x") : (this.isSetUID() ? result + "S" : result + "-");
            result = this.canGroupRead() ? result + "r" : result + "-";
            result = this.canGroupWrite() ? result + "w" : result + "-";
            result = this.canGroupExecute() ? (this.isSetGID() ? result + "s" : result + "x") : (this.isSetGID() ? result + "S" : result + "-");
            result = this.canOthersRead() ? result + "r" : result + "-";
            result = this.canOthersWrite() ? result + "w" : result + "-";
            result = this.canOthersExecute() ? (this.isStickyBit() ? result + "t" : result + "x") : (this.isStickyBit() ? result + "T" : result + "-");
            return result;
        }
    }

    public static abstract class POSIXFileAttributes {
        public static final byte FILETYPE_UNDEFINED = 0;
        public static final byte FILETYPE_FIFO = 1;
        public static final byte FILETYPE_CHARACTER_SPECIAL = 2;
        public static final byte FILETYPE_DIRECTORY = 4;
        public static final byte FILETYPE_BLOCK_SPECIAL = 6;
        public static final byte FILETYPE_REGULAR = 8;
        public static final byte FILETYPE_SYMBOLIC_LINK = 10;
        public static final byte FILETYPE_SOCKET = 12;
        public static final byte FILETYPE_WHITEOUT = 14;

        public abstract long getUserID();

        public abstract long getGroupID();

        public abstract byte getFileType();

        public abstract boolean canUserRead();

        public abstract boolean canUserWrite();

        public abstract boolean canUserExecute();

        public abstract boolean canGroupRead();

        public abstract boolean canGroupWrite();

        public abstract boolean canGroupExecute();

        public abstract boolean canOthersRead();

        public abstract boolean canOthersWrite();

        public abstract boolean canOthersExecute();

        public abstract boolean isSetUID();

        public abstract boolean isSetGID();

        public abstract boolean isStickyBit();

        public abstract String getPermissionString();
    }
}

